<?php

class ControladorEmpresas
{

  /*=============================================
	CREAR EMPRESA
	=============================================*/
  static public function ctrCrearEmpresa($ruta)
  {
    if (isset($_POST["nombre"])) {
      $nombre = trim($_POST["nombre"]);
      // Validación de caracteres especiales usando preg_match
      if (preg_match('/[!@#$%^&*,.?":{}|<>]/', $nombre)) {
        echo '<script>
              Swal.fire({
                  icon: "error",
                  title: "El nombre de empresa no puede contener caracteres especiales",
                  showConfirmButton: true,
                  confirmButtonText: "Cerrar"
              }).then(function(result){
                  if (result.isConfirmed) {
                      window.location = "empresas";
                  }
              });
          </script>';
      } else {
        try {
          $tabla = "empresas";
          $respuesta = ModeloEmpresas::mdlIngresarEmpresa($tabla, $nombre);

          if ($respuesta) {
            echo '<script>
              toastr.options = {
                "closeButton": true,
                "debug": true,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": true,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "3000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
              };
              toastr["success"]("Empresa guardada correctamente.", "Listo!");
              setTimeout(function() {
                  window.location = "empresas";
              }, 1800);
            </script>';
          } else {
            echo '<script>
              toastr.options = {
                "closeButton": true,
                "debug": true,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": true,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
              }
              toastr["error"]("Error al guardar Empresa!", "Error!");
              setTimeout(function() {
                window.location = "empresas";
            }, 1800);
            </script>';
          }
        } catch (Exception $e) {
          echo '<script>
                  Swal.fire({
                      icon: "error",
                      title: "Error al ingresar la empresa: ' . $e->getMessage() . '",
                      showConfirmButton: true,
                      confirmButtonText: "Cerrar"
                  }).then(function(result){
                      if (result.isConfirmed) {
                          window.location = "empresas";
                      }
                  });
              </script>';
        }
      }
    }
  }

  /*=============================================
	MOSTRAR EMPRESAS
	=============================================*/
  static public function ctrMostrarEmpresas($item, $valor)
  {

    $tabla = "empresas";

    $respuesta = ModeloEmpresas::mdlMostrarEmpresas($tabla, $item, $valor);

    return $respuesta;
  }

  /*=============================================
	EDITAR EMPRESA
	=============================================*/
  static public function ctrEditarEmpresa()
  {

    if (isset($_POST["editarEmpresa"])) {
      $nombre = trim($_POST["editarEmpresa"]);
      if (!preg_match('/[!@#$%^&*,.?":{}|<>]/', $nombre)) {

        $tabla = "empresas";

        $datos = array(
          "nombre" => $_POST["editarEmpresa"],
          "id" => $_POST["idEmpresa"]
        );

        $respuesta = ModeloEmpresas::mdlEditarEmpresa($tabla, $datos);

        if ($respuesta) {
          echo '<script>
            toastr.options = {
              "closeButton": true,
              "debug": true,
              "newestOnTop": false,
              "progressBar": true,
              "positionClass": "toast-top-right",
              "preventDuplicates": true,
              "showDuration": "300",
              "hideDuration": "1000",
              "timeOut": "3000",
              "extendedTimeOut": "1000",
              "showEasing": "swing",
              "hideEasing": "linear",
              "showMethod": "fadeIn",
              "hideMethod": "fadeOut"
            };
            toastr["success"]("Empresa modificada correctamente.", "Listo!");
            setTimeout(function() {
                window.location = "empresas";
            }, 1800);
          </script>';
        } else {
          echo '<script>
            toastr.options = {
              "closeButton": true,
              "debug": true,
              "newestOnTop": false,
              "progressBar": true,
              "positionClass": "toast-top-right",
              "preventDuplicates": true,
              "showDuration": "300",
              "hideDuration": "1000",
              "timeOut": "5000",
              "extendedTimeOut": "1000",
              "showEasing": "swing",
              "hideEasing": "linear",
              "showMethod": "fadeIn",
              "hideMethod": "fadeOut"
            }
            toastr["error"]("Error al modificar Empresa!", "Error!");
            setTimeout(function() {
              window.location = "empresas";
          }, 1800);
          </script>';
        }
      } else {

        echo '<script>
              Swal.fire({
                  icon: "error",
                  title: "El nombre de empresa no puede contener caracteres especiales",
                  showConfirmButton: true,
                  confirmButtonText: "Cerrar"
              }).then(function(result){
                  if (result.isConfirmed) {
                      window.location = "empresas";
                  }
              });
          </script>';
      }
    }
  }

  /*=============================================
	BORRAR EMPRESA
	=============================================*/

  static public function ctrBorrarEmpresa()
  {

    if (isset($_GET["idEmpresa"])) {

      $tabla = "empresas";
      $datos = $_GET["idEmpresa"];

      $respuesta = ModeloEmpresas::mdlBorrarEmpresa($tabla, $datos);

      if ($respuesta) {

        echo '<script>
    
            window.location = "index.php?ruta=empresas&status=BORRADO";
    
            </script>';
      } else {
        echo '<script>
  
    
            window.location = "index.php?ruta=empresas&status=ERROR";
    
           </script>';
      }
    }
  }
}
