<?php

class ControladorHoteles
{

    static public function ctrTotalHoteles()
    {
        $tabla = "hoteles";

        $respuesta = ModeloHoteles::mdlTotalHoteles($tabla);

        return $respuesta;
    }

    /*=============================================
	CREAR HOTEL
	=============================================*/
    static public function ctrCrearHotel($ruta)
    {
        if (isset($_POST["nombre"])) {
            $nombre = trim($_POST["nombre"]);
            // Validación de caracteres especiales usando preg_match
            if (preg_match('/[!@#$%^&*,.?":{}|<>]/', $nombre)) {
                echo '<script>
              Swal.fire({
                  icon: "error",
                  title: "El nombre del hotel no puede contener caracteres especiales",
                  showConfirmButton: true,
                  confirmButtonText: "Cerrar"
              }).then(function(result){
                  if (result.isConfirmed) {
                      window.location = "hoteles";
                  }
              });
          </script>';
            } else {
                try {
                    $tabla = "hoteles";
                    $respuesta = ModeloHoteles::mdlIngresarHotel($tabla, $nombre);

                    if ($respuesta) {
                        echo '<script>
              toastr.options = {
                "closeButton": true,
                "debug": true,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": true,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "3000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
              };
              toastr["success"]("Hotel guardado correctamente.", "Listo!");
              setTimeout(function() {
                  window.location = "hoteles";
              }, 1800);
            </script>';
                    } else {
                        echo '<script>
              toastr.options = {
                "closeButton": true,
                "debug": true,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": true,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
              }
              toastr["error"]("Error al guardar Hotel!", "Error!");
              setTimeout(function() {
                window.location = "empresas";
            }, 1800);
            </script>';
                    }
                } catch (Exception $e) {
                    echo '<script>
                  Swal.fire({
                      icon: "error",
                      title: "Error al ingresar Hotel: ' . $e->getMessage() . '",
                      showConfirmButton: true,
                      confirmButtonText: "Cerrar"
                  }).then(function(result){
                      if (result.isConfirmed) {
                          window.location = "hoteles";
                      }
                  });
              </script>';
                }
            }
        }
    }

    /*=============================================
	MOSTRAR HOTELES
	=============================================*/
    static public function ctrMostrarHoteles($item, $valor)
    {

        $tabla = "hoteles";

        $respuesta = ModeloHoteles::mdlMostrarHoteles($tabla, $item, $valor);

        return $respuesta;
    }

    /*=============================================
	EDITAR HOTEL
	=============================================*/
    static public function ctrEditarHotel()
    {
        if (isset($_POST["editarHotel"])) {
            $nombre = trim($_POST["editarHotel"]);
            if (!preg_match('/[!@#$%^&*,.?":{}|<>]/', $nombre)) {

                $tabla = "hoteles";

                $datos = array(
                    "nombre" => $nombre,
                    "id" => $_POST["idHotel"]
                );

                $respuesta = ModeloHoteles::mdlEditarHotel($tabla, $datos);

                if ($respuesta) {
                    echo '<script>
            toastr.options = {
              "closeButton": true,
              "debug": true,
              "newestOnTop": false,
              "progressBar": true,
              "positionClass": "toast-top-right",
              "preventDuplicates": true,
              "showDuration": "300",
              "hideDuration": "1000",
              "timeOut": "3000",
              "extendedTimeOut": "1000",
              "showEasing": "swing",
              "hideEasing": "linear",
              "showMethod": "fadeIn",
              "hideMethod": "fadeOut"
            };
            toastr["success"]("Hotel modificado correctamente.", "Listo!");
            setTimeout(function() {
                window.location = "hoteles";
            }, 1800);
          </script>';
                } else {
                    echo '<script>
            toastr.options = {
              "closeButton": true,
              "debug": true,
              "newestOnTop": false,
              "progressBar": true,
              "positionClass": "toast-top-right",
              "preventDuplicates": true,
              "showDuration": "300",
              "hideDuration": "1000",
              "timeOut": "5000",
              "extendedTimeOut": "1000",
              "showEasing": "swing",
              "hideEasing": "linear",
              "showMethod": "fadeIn",
              "hideMethod": "fadeOut"
            }
            toastr["error"]("Error al modificar Hotel!", "Error!");
            setTimeout(function() {
              window.location = "hoteles";
          }, 1800);
          </script>';
                }
            } else {

                echo '<script>
              Swal.fire({
                  icon: "error",
                  title: "El nombre del Hotel no puede contener caracteres especiales",
                  showConfirmButton: true,
                  confirmButtonText: "Cerrar"
              }).then(function(result){
                  if (result.isConfirmed) {
                      window.location = "hoteles";
                  }
              });
          </script>';
            }
        }
    }

    /*=============================================
	BORRAR HOTEL
	=============================================*/
    static public function ctrBorrarCategoria()
    {

        if (isset($_GET["idCategoria"])) {

            $tabla = "Categorias";
            $datos = $_GET["idCategoria"];

            $respuesta = ModeloCategorias::mdlBorrarCategoria($tabla, $datos);

            if ($respuesta == "ok") {

                echo '<script>

					swal({
						  type: "success",
						  title: "La categoría ha sido borrada correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "categorias";

									}
								})

					</script>';
            }
        }
    }
}
