<?php

class ControladorPedidos
{

  static public function ctrEditandoPedido($pedido, $estado)
  {
    $tabla = "pedidos";
    $respuesta = ModeloPedidos::mdlEditandoPedido($tabla, $pedido, $estado);
    return $respuesta;
  }

  static public function ctrTotalPedidos()
  {
    $tabla = "pedidos";

    $respuesta = ModeloPedidos::mdlTotalPedidos($tabla);

    return $respuesta;
  }

  static public function ctrTotalPedidosByCoordinador($coordinador)
  {
    $tabla = "pedidos";

    $respuesta = ModeloPedidos::mdlTotalPedidosByCoordinador($tabla, $coordinador);

    return $respuesta;
  }

  /*=============================================
	MOSTRAR PEDIDOS
	=============================================*/
  static public function ctrMostrarPedidos($item, $valor)
  {

    $tabla = "pedidos";

    $respuesta = ModeloPedidos::mdlMostrarPedidos($tabla, $item, $valor);

    return $respuesta;
  }

  /*=============================================
	MOSTRAR PEDIDOS POR VENDEDOR
	=============================================*/
  static public function ctrMostrarPedidosByVendedor($item, $valor)
  {

    $tabla = "pedidos";

    $respuesta = ModeloPedidos::mdlMostrarPedidosByVendedor($tabla, $item, $valor);

    return $respuesta;
  }


  static public function generarCodigoAleatorio()
  {
    $codigo = '';
    $digitos = 5;

    do {
      // Generar un número aleatorio de 5 dígitos
      $codigo = str_pad(rand(0, pow(10, $digitos) - 1), $digitos, '0', STR_PAD_LEFT);
    } while (!self::esCodigoUnico($codigo));

    return $codigo;
  }

  static public function esCodigoUnico($codigo)
  {
    $codigoRepetido = false;

    return !$codigoRepetido;
  }

  /*=============================================
	CREAR PEDIDO
	=============================================*/
  static public function ctrCrearPedido()
  {
    $pagoEnHotel = null;
    $cerrado = null;
    if (isset($_POST["guardarPedido"])) {

      $pagoEnHotel = isset($_POST['pagoEnHotel']) && $_POST['pagoEnHotel'] == 1 ? 1 : NULL;

      if ($_POST["listaProductos"] == "") {

        echo '<script>
        alert("Seleccione al menos un producto para continuar");
				</script>';

        return;
      }

      $coordinadorId = $_POST["coordinadorId"];

      $listaProductos = json_decode($_POST["listaProductos"], true);

      $totalProductosComprados = array();

      foreach ($listaProductos as $key => $value) {

        array_push($totalProductosComprados, $value["cantidad"]);

        $tablaProductos = "productos";

        $item = "id";
        $valor = $value["id"];
        $orden = "id";

        $traerProducto = ModeloProductos::mdlMostrarProductos($tablaProductos, $item, $valor, $orden, null);
      }

      $tabla = "pedidos";

      $fechaPedido = date("Y-m-d");

      $descuento = !empty($_POST["nuevoDescuento"]) ? $_POST["nuevoDescuento"] : null;
      $importe_debe = !empty($_POST["nuevoTotalDebe"]) ? $_POST["nuevoTotalDebe"] : null;

      // Eliminar la coma como separador de miles
      $numero_sin_coma = str_replace(",", "", $_POST["nuevoTotalPago"]);

      if ($pagoEnHotel == 1) {
        $numero_sin_coma = 0.00;
        $importe_debe = $_POST["totalVenta"];
      }

      // Convertir la cadena resultante en un número
      $numero = (float) $numero_sin_coma;

      // Formatear el número con dos decimales y punto como separador decimal
      $numero_formateado = number_format($numero, 2, '.', '');

      $datos = array(
        "id_vendedor" => $_POST["idVendedor"],
        "productos" => $_POST["listaProductos"],
        "importe_neto" => $_POST["nuevoPrecioNeto"],
        "importe_total" => $_POST["totalVenta"],
        "nro_habitacion" => $_POST["nroHabitacion"],
        "nombre_pax" => $_POST["nombrePax"],
        "fecha_entrega" => $_POST["fecha_entrega"],
        "fecha_pedido" => $fechaPedido,
        "codigo" => self::generarCodigoAleatorio(),
        "descuento" => $descuento,
        "nuevo_total_pago" => $numero_formateado,
        "importe_debe" => $importe_debe,
        "id_coordinador" => $_POST["idCoordinador"],
        "pago_en_hotel" => $pagoEnHotel,
        "cerrado" => null
      );

      $respuesta = ModeloPedidos::mdlIngresarPedido($tabla, $datos);

      //echo $respuesta;
      if ($respuesta[1]) {
        $mensaje = 'Pedido N° ' . $respuesta[0] . ' guardado correctamente';
        echo '<script>
        localStorage.removeItem("rango");

        Swal.fire({
            title: "' . $mensaje . '",
            icon: "success",
            showConfirmButton: true,
            confirmButtonText: "OK",
            allowOutsideClick: false
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: "¿Quiere cargar un nuevo pedido?",
                    icon: "question",
                    showCancelButton: true,
                    confirmButtonText: "Sí, cargar nuevo pedido",
                    cancelButtonText: "No, continuar",
                    allowOutsideClick: false
                }).then((result) => {
                    if (result.isConfirmed) {
                      window.location = "index.php?ruta=crear-pedido&coordinador=' . $coordinadorId . '";
                    } else {
                      window.location = "index.php?ruta=pedidos";
                    }
                });
            }
        });
    </script>';
      } else {
        echo '<script>

				localStorage.removeItem("rango");

				window.location = "index.php?ruta=pedidos&status=ERROR";

				</script>';
      }
    }
  }

  /*=============================================
  COBRAR PEDIDO
  ==============================================*/
  static public function ctrCobrarPedido($pedido = null)
  {
    $timestamp = time();
    $fechaHora = date('Y-m-d H:i:s', $timestamp);
    if (isset($_POST["cobrarPedido"]) || $pedido != null) {

      $tabla = "pedidos";

      $item = "id";
      $valor = $pedido != null ? $pedido : $_POST["editarPedido"];

      $traerPedido = ModeloPedidos::mdlMostrarPedidos($tabla, $item, $valor);
      $cobrar = "COBRADO";

      $datos = array(
        "id_pedido" => $traerPedido["id"],
        "estado" => $cobrar,
        "fecha_pago" => $fechaHora,
        "cerrado" => 1
      );

      $respuesta = ModeloPedidos::mdlCobrarPedido($tabla, $datos);

      if ($respuesta) {

        echo '<script>

				localStorage.removeItem("rango");

				window.location = "index.php?ruta=pedidos&cobrado=COBRADO";

				</script>';
      } else {
        echo '<script>

				localStorage.removeItem("rango");

				window.location = "index.php?ruta=pedidos&status=ERROR";

				</script>';
      }
    }
  }

  /*=============================================
	EDITAR PEDIDO
	=============================================*/
  static public function ctrEditarPedido()
  {
    $pagoEnHotel = null;
    $cerrado = null;

    if (isset($_POST["guardarPedido"])) {

      $pagoEnHotel = isset($_POST['pagoEnHotel']) && $_POST['pagoEnHotel'] == 1 ? 1 : NULL;
      /*=============================================
			FORMATEAR TABLA DE PRODUCTOS Y LA DE CLIENTES
			=============================================*/
      $tabla = "pedidos";

      $item = "id";
      $valor = $_POST["editarPedido"];

      $traerPedido = ModeloPedidos::mdlMostrarPedidos($tabla, $item, $valor);

      /*=============================================
			REVISAR SI VIENE PRODUCTOS EDITADOS
			=============================================*/
      if ($_POST["listaProductos"] == "") {

        $listaProductos = $traerPedido["productos"];
        $cambioProducto = false;
      } else {

        $listaProductos = $_POST["listaProductos"];
        $cambioProducto = true;
      }

      if ($cambioProducto) {

        $productos =  json_decode($traerPedido["productos"], true);

        $totalProductosComprados = array();

        foreach ($productos as $key => $value) {

          array_push($totalProductosComprados, $value["cantidad"]);

          $tablaProductos = "productos";

          $item = "id";
          $valor = $value["id"];
          $orden = "id";

          $traerProducto = ModeloProductos::mdlMostrarProductos($tablaProductos, $item, $valor, $orden, null);
        }
      }

      /*=============================================
			GUARDAR CAMBIOS DEL PEDIDO
			=============================================*/

      if (isset($_POST['cerrarPedido']) && $_POST['cerrarPedido'] === 'CERRADO') {
        $estadoPedido = "COBRADO";
      } else {
        $estadoPedido = "IMPAGO";
      }

      if ($pagoEnHotel == 1) {
        $numero_sin_coma = 0.00;
        $importe_debe = $_POST["totalVenta"];
        $cerrado = null;
      }

      $descuento = !empty($_POST["nuevoDescuento"]) ? $_POST["nuevoDescuento"] : null;
      $importe_debe = !empty($_POST["nuevoTotalDebe"]) ? $_POST["nuevoTotalDebe"] : null;

      // Eliminar la coma como separador de miles
      $numero_sin_coma = str_replace(",", "", $_POST["nuevoTotalPago"]);

      // Convertir la cadena resultante en un número
      $numero = (float) $numero_sin_coma;

      // Formatear el número con dos decimales y punto como separador decimal
      $numero_formateado = number_format($numero, 2, '.', '');

      $datos = array(
        "id_pedido" => $traerPedido["id"],
        "id_vendedor" => $traerPedido["id_vendedor"],
        "id_coordinador" => $traerPedido["id_coordinador"],
        "productos" => $listaProductos,
        "importe_neto" => $_POST["nuevoPrecioNeto"],
        "importe_total" => $_POST["totalVenta"],
        "nro_habitacion" => $_POST["nroHabitacion"],
        "descuento" => $descuento,
        "nuevo_total_pago" => $numero_formateado,
        "importe_debe" => $importe_debe,
        "nombre_pax" => $_POST["nombrePax"],
        "estado" => $estadoPedido,
        "cerrado" => $cerrado,
        "pago_en_hotel" => $pagoEnHotel,
        "fecha_pago" => null
      );

      $respuesta = ModeloPedidos::mdlEditarPedido($tabla, $datos);


      if ($respuesta) {


        if ($_SESSION["perfil"] == "Vendedor") {

          echo '<script>

				localStorage.removeItem("rango");

				window.location = "index.php?ruta=pedidos&modificado=MODIFICADO";

				</script>';
        } else {

          echo '<script>

				localStorage.removeItem("rango");

				window.location = "index.php?ruta=editar-pedido&idPedido=' . $respuesta . '&estado=MODIFICADO";

				</script>';
        }
      } else {
        echo '<script>

				localStorage.removeItem("rango");

				window.location = "index.php?ruta=pedidos&status=ERROR";

				</script>';
      }
    }
  }

  /*================================================================
	EDITAR Y COBRAR PEDIDO (ESTE MÉTODO UTILIZAN LOS USUARIOS CAJEROS)
	=================================================================*/
  static public function ctrEditarCobrarPedido()
  {
    $pagoEnHotel = null;
    $timestamp = time();
    $fechaHora = date('Y-m-d H:i:s', $timestamp);

    if (isset($_POST["editarCobrarPedido"])) {

      $pagoEnHotel = isset($_POST['pagoEnHotel']) && $_POST['pagoEnHotel'] == 1 ? 1 : NULL;
      /*=============================================
			FORMATEAR TABLA DE PRODUCTOS Y LA DE CLIENTES
			=============================================*/
      $tabla = "pedidos";

      $item = "id";
      $valor = $_POST["editarPedido"];

      $traerPedido = ModeloPedidos::mdlMostrarPedidos($tabla, $item, $valor);

      /*=============================================
			REVISAR SI VIENE PRODUCTOS EDITADOS
			=============================================*/
      if ($_POST["listaProductos"] == "") {

        $listaProductos = $traerPedido["productos"];
        $cambioProducto = false;
      } else {

        $listaProductos = $_POST["listaProductos"];
        $cambioProducto = true;
      }

      if ($cambioProducto) {

        $productos =  json_decode($traerPedido["productos"], true);

        $totalProductosComprados = array();

        foreach ($productos as $key => $value) {

          array_push($totalProductosComprados, $value["cantidad"]);

          $tablaProductos = "productos";

          $item = "id";
          $valor = $value["id"];
          $orden = "id";

          $traerProducto = ModeloProductos::mdlMostrarProductos($tablaProductos, $item, $valor, $orden, null);
        }
      }

      /*=============================================
			GUARDAR CAMBIOS DEL PEDIDO
			=============================================*/
      $importe_debe = !empty($_POST["nuevoTotalDebe"]) ? $_POST["nuevoTotalDebe"] : null;
      if ($pagoEnHotel === 1) {
        $numero_sin_coma = 0.00;
        $importe_debe = $_POST["totalVenta"];
      } else {
        $importe_debe = 0.00;
      }

      /*echo "Debug: <br>";
      echo "Pago hotel: ".$pagoEnHotel;
      echo "<br>Descuento: ".$_POST["nuevoDescuento"];
      echo "<br>Saldo pago: ".$_POST["nuevoTotalDebe"];
      echo "<br>Importe total pedido: ".$_POST["totalVenta"];
      echo "<br>Estoy pagando: ".$_POST["nuevoTotalPago"];

      exit();*/

      $descuento = !empty($_POST["nuevoDescuento"]) ? $_POST["nuevoDescuento"] : null;

      // Preparar Total Venta Eliminar la coma como separador de miles
      $total_venta = str_replace(",", "", $_POST["totalVenta"]);

      // Convertir la cadena resultante en un número
      $numero_total_venta = (float) $total_venta;

      // Formatear el número con dos decimales y punto como separador decimal
      $total_venta = number_format($numero_total_venta, 2, '.', '');

      ////////////

      // Preparar monto Saldo Eliminar la coma como separador de miles
      $numero_sin_coma = str_replace(",", "", $_POST["nuevoTotalPago"]);

      // Convertir la cadena resultante en un número
      $numero = (float) $numero_sin_coma;

      // Formatear el número con dos decimales y punto como separador decimal
      $numero_formateado = number_format($numero, 2, '.', '');

      // Preparar monto Pago parcial
      $importe_debe = str_replace(",", "", $_POST["nuevoTotalDebe"]);
      // Convertir la cadena resultante en un número
      $monto_debe = (float) $importe_debe;
      // Formatear el número con dos decimales y punto como separador decimal
      $saldo = number_format($monto_debe, 2, '.', '');

      // Chequear si se paga en hotel
      if($pagoEnHotel === 1){

        // Si el monto pagado es igual al total venta que es el saldo deudor
        if($numero_formateado == $total_venta){
          $saldo = $numero_formateado;
          $numero_formateado = number_format(0, 2, '.','');
        }else{
          $saldo = number_format($total_venta - $numero_formateado, 2, '.', '');
        }
      }

      $datos = array(
        "id_pedido" => $traerPedido["id"],
        "id_vendedor" => $traerPedido["id_vendedor"],
        "id_coordinador" => $traerPedido["id_coordinador"],
        "productos" => $listaProductos,
        "importe_neto" => $_POST["nuevoPrecioNeto"],
        "importe_total" => $_POST["totalVenta"],
        "nro_habitacion" => $_POST["nroHabitacion"],
        "descuento" => $descuento,
        "nuevo_total_pago" => $numero_formateado,
        "importe_debe" => $saldo,
        "nombre_pax" => $_POST["nombrePax"],
        "estado" => "COBRADO",
        "cerrado" => 1,
        "pago_en_hotel" => $pagoEnHotel,
        "fecha_pago" => $fechaHora
      );

      /*echo(json_encode($datos, true));
      exit();*/

      $respuesta = ModeloPedidos::mdlEditarPedido($tabla, $datos);

      if ($respuesta) {

        echo '<script>

				localStorage.removeItem("rango");

				window.location = "index.php?ruta=pedidos&modificado=MODIFICADO";

				</script>';
      } else {
        echo '<script>

				localStorage.removeItem("rango");

				window.location = "index.php?ruta=pedidos&status=ERROR";

				</script>';
      }
    }
  }

  /*===================================================================================================
	EDITAR PEDIDO ADMIN (ESTE MÉTODO LO USAN LOS ADMIN PARA EDITAR PEDIDOS A PARTIR DE LOS COORDINADORES)
	====================================================================================================*/
  static public function ctrEditarPedidoAdmin()
  {
    if (isset($_POST["guardarPedido"])) {

      $pagoEnHotel = isset($_POST['pagoEnHotel']) && $_POST['pagoEnHotel'] == 1 ? 1 : NULL;
      /*=============================================
			FORMATEAR TABLA DE PRODUCTOS Y LA DE CLIENTES
			=============================================*/
      $tabla = "pedidos";

      $item = "id";
      $valor = $_POST["editarPedido"];

      $traerPedido = ModeloPedidos::mdlMostrarPedidos($tabla, $item, $valor);

      /*=============================================
			REVISAR SI VIENE PRODUCTOS EDITADOS
			=============================================*/
      if ($_POST["listaProductos"] == "") {

        $listaProductos = $traerPedido["productos"];
        $cambioProducto = false;
      } else {

        $listaProductos = $_POST["listaProductos"];
        $cambioProducto = true;
      }

      if ($cambioProducto) {

        $productos =  json_decode($traerPedido["productos"], true);

        $totalProductosComprados = array();

        foreach ($productos as $key => $value) {

          array_push($totalProductosComprados, $value["cantidad"]);

          $tablaProductos = "productos";

          $item = "id";
          $valor = $value["id"];
          $orden = "id";

          $traerProducto = ModeloProductos::mdlMostrarProductos($tablaProductos, $item, $valor, $orden, null);
        }
      }

      /*=============================================
			GUARDAR CAMBIOS DEL PEDIDO
			=============================================*/

      $descuento = !empty($_POST["nuevoDescuento"]) ? $_POST["nuevoDescuento"] : null;
      $importe_debe = !empty($_POST["nuevoTotalDebe"]) ? $_POST["nuevoTotalDebe"] : null;

      // Preparar Total Venta Eliminar la coma como separador de miles
      $total_venta = str_replace(",", "", $_POST["totalVenta"]);

      // Convertir la cadena resultante en un número
      $numero_total_venta = (float) $total_venta;

      // Formatear el número con dos decimales y punto como separador decimal
      $total_venta = number_format($numero_total_venta, 2, '.', '');

      ////////////

      // Eliminar la coma como separador de miles
      $numero_sin_coma = str_replace(",", "", $_POST["nuevoTotalPago"]);

      // Convertir la cadena resultante en un número
      $numero = (float) $numero_sin_coma;

      // Formatear el número con dos decimales y punto como separador decimal
      $numero_formateado = number_format($numero, 2, '.', '');

      /*if ($pagoEnHotel == 1) {
        $numero_sin_coma = 0.00;
        $importe_debe = $_POST["totalVenta"];
        $numero_formateado = 0.00;
      } else {
        $importe_debe = 0.00;
      }*/

      // Preparar monto Pago parcial
      $importe_debe = str_replace(",", "", $_POST["nuevoTotalDebe"]);
      // Convertir la cadena resultante en un número
      $monto_debe = (float) $importe_debe;
      // Formatear el número con dos decimales y punto como separador decimal
      $saldo = number_format($monto_debe, 2, '.', '');

      /*echo "Debug: <br>";
      echo "Pago hotel: ".$pagoEnHotel;
      echo "<br>Descuento: ".$_POST["nuevoDescuento"];
      echo "<br>Saldo pago: ".$_POST["nuevoTotalDebe"];
      echo "<br>Importe total pedido: ".$_POST["totalVenta"];
      echo "<br>Estoy pagando: ".$_POST["nuevoTotalPago"];

      exit();*/

      // Chequear si se paga en hotel
      if($pagoEnHotel === 1){

        // Si el monto pagado es igual al total venta que es el saldo deudor
        if($numero_formateado == $total_venta){
          $saldo = $numero_formateado;
          $numero_formateado = number_format(0, 2, '.','');
        }else{
          $saldo = number_format($total_venta - $numero_formateado, 2, '.', '');
        }
      }

      $datos = array(
        "id_pedido" => $traerPedido["id"],
        "id_vendedor" => $traerPedido["id_vendedor"],
        "productos" => $listaProductos,
        "importe_neto" => $_POST["nuevoPrecioNeto"],
        "importe_total" => $_POST["totalVenta"],
        "nro_habitacion" => $_POST["nroHabitacion"],
        "descuento" => $descuento,
        "nuevo_total_pago" => $numero_formateado,
        "importe_debe" => $saldo,
        "nombre_pax" => $_POST["nombrePax"],
        "pago_en_hotel" => $pagoEnHotel
      );

      /*echo(json_encode($datos, true));
      exit();*/

      $respuesta = ModeloPedidos::mdlEditarPedidoAdmin($tabla, $datos);


      if ($respuesta) {

        echo '<script>

				localStorage.removeItem("rango");

				window.location = "index.php?ruta=pedidos&modificado=MODIFICADO";

				</script>';
      } else {
        echo '<script>

				localStorage.removeItem("rango");

				window.location = "index.php?ruta=pedidos&status=ERROR";

				</script>';
      }
    }
  }

  /*=============================================
	ELIMINAR PEDIDO
	=============================================*/
  static public function ctrEliminarPedido($ruta)
  {

    if (isset($_GET["idPedido"])) {

      $tabla = "pedidos";

      $respuesta = ModeloPedidos::mdlEliminarPedido($tabla, $_GET["idPedido"]);

      if ($respuesta == "ok") {

        echo '<script>

            let timerInterval
            Swal.fire({
              title: "Pedido anulado correctamente",
              timer: 1200,
              timerProgressBar: true,
              didOpen: () => {
                Swal.showLoading()
                const b = Swal.getHtmlContainer().querySelector("b")
                timerInterval = setInterval(() => {
                  b.textContent = Swal.getTimerLeft()
                }, 100)
              },
              willClose: () => {
                clearInterval(timerInterval)
                window.location = "index.php?ruta=' . $ruta . '";
              }
            }).then((result) => {
              /* Read more about handling dismissals below */
              if (result.dismiss === Swal.DismissReason.timer) {
                console.log("I was closed by the timer")
              }
            })


				</script>';
      }
    }
  }


  /*=============================================
	HISTORIAL DE PEDIDOS
	=============================================*/

  static public function ctrHistorialPedidos($fechaInicial, $fechaFinal)
  {

    $tabla = "pedidos";

    $respuesta = ModeloPedidos::mdlHistorialPedidos($tabla, $fechaInicial, $fechaFinal);

    return $respuesta;
  }

  /*=============================================
	RANGO FECHAS
	=============================================*/

  static public function ctrRangoFechasPedidos($fechaInicial, $fechaFinal, $usuario = null, $cerrado = null)
  {

    $tabla = "pedidos";

    $respuesta = ModeloPedidos::mdlRangoFechasPedidos($tabla, $fechaInicial, $fechaFinal, $usuario, $cerrado);

    return $respuesta;
  }

  static public function ctrPedidosPorGrupo($fechaInicial, $cerrado)
  {

    $respuesta = ModeloPedidos::mdlPedidosPorGrupo($fechaInicial, $cerrado);

    return $respuesta;
  }

  static public function ctrPedidosPorGrupoCerrados($fechaInicial)
  {

    $respuesta = ModeloPedidos::mdlPedidosPorGrupoCerrados($fechaInicial);

    return $respuesta;
  }


  static public function ctrRangoFechasVentasCoordinador($fechaInicial, $fechaFinal, $coordinador)
  {
    $tabla = "pedidos";
    $respuesta = ModeloPedidos::mdlRangoFechasVentasCoordinador($tabla, $fechaInicial, $fechaFinal, $coordinador);
    return $respuesta;
  }

  /*=============================================
	DESCARGAR EXCEL
	=============================================*/

  public function ctrDescargarReporte()
  {

    if (isset($_GET["reporte"])) {

      $tabla = "pedidos";

      if (isset($_GET["fechaInicial"]) && isset($_GET["fechaFinal"])) {

        $ventas = ModeloPedidos::mdlRangoFechasPedidos($tabla, $_GET["fechaInicial"], $_GET["fechaFinal"], null, null);
      } else {

        $item = null;
        $valor = null;

        $ventas = ModeloPedidos::mdlMostrarPedidos($tabla, $item, $valor);
      }


      /*=============================================
			CREAMOS EL ARCHIVO DE EXCEL
			=============================================*/

      $Name = $_GET["reporte"] . '.xls';

      header('Expires: 0');
      header('Cache-control: private');
      header("Content-type: application/vnd.ms-excel"); // Archivo de Excel
      header("Cache-Control: cache, must-revalidate");
      header('Content-Description: File Transfer');
      header('Last-Modified: ' . date('D, d M Y H:i:s'));
      header("Pragma: public");
      header('Content-Disposition:; filename="' . $Name . '"');
      header("Content-Transfer-Encoding: binary");

      echo utf8_decode("<table border='0'> 

					<tr> 
					<td style='font-weight:bold; border:1px solid #eee;'>CÓDIGO</td> 
					<td style='font-weight:bold; border:1px solid #eee;'>CLIENTE</td>
					<td style='font-weight:bold; border:1px solid #eee;'>VENDEDOR</td>
					<td style='font-weight:bold; border:1px solid #eee;'>CANTIDAD</td>
					<td style='font-weight:bold; border:1px solid #eee;'>PRODUCTOS</td>
					<td style='font-weight:bold; border:1px solid #eee;'>IMPUESTO</td>
					<td style='font-weight:bold; border:1px solid #eee;'>NETO</td>		
					<td style='font-weight:bold; border:1px solid #eee;'>TOTAL</td>		
					<td style='font-weight:bold; border:1px solid #eee;'>METODO DE PAGO</td	
					<td style='font-weight:bold; border:1px solid #eee;'>FECHA</td>		
					</tr>");

      foreach ($ventas as $row => $item) {

        $cliente = ControladorCoordinadores::ctrMostrarCoordinadores("id", $item["id_coordinador"]);
        $vendedor = ControladorUsuarios::ctrMostrarUsuarios("id", $item["id_vendedor"]);

        echo utf8_decode("<tr>
			 			<td style='border:1px solid #eee;'>" . $item["codigo"] . "</td> 
			 			<td style='border:1px solid #eee;'>" . $cliente["nombre"] . "</td>
			 			<td style='border:1px solid #eee;'>" . $vendedor["nombre"] . "</td>
			 			<td style='border:1px solid #eee;'>");

        $productos =  json_decode($item["productos"], true);

        foreach ($productos as $key => $valueProductos) {

          echo utf8_decode($valueProductos["cantidad"] . "<br>");
        }

        echo utf8_decode("</td><td style='border:1px solid #eee;'>");

        foreach ($productos as $key => $valueProductos) {

          echo utf8_decode($valueProductos["descripcion"] . "<br>");
        }

        echo utf8_decode("</td>
					<td style='border:1px solid #eee;'>$ " . number_format($item["impuesto"], 2) . "</td>
					<td style='border:1px solid #eee;'>$ " . number_format($item["neto"], 2) . "</td>	
					<td style='border:1px solid #eee;'>$ " . number_format($item["total"], 2) . "</td>
					<td style='border:1px solid #eee;'>" . $item["metodo_pago"] . "</td>
					<td style='border:1px solid #eee;'>" . substr($item["fecha"], 0, 10) . "</td>		
		 			</tr>");
      }


      echo "</table>";
    }
  }


  /*=============================================
	SUMA TOTAL VENTAS
	=============================================*/

  static public function ctrSumaTotalVentas()
  {

    $tabla = "pedidos";

    $respuesta = ModeloPedidos::mdlSumaTotalPedidos($tabla);

    return $respuesta;
  }
}
