<?php
require_once 'autoload.inc.php';

use Dompdf\Dompdf;

$dompdf = new Dompdf();
$dompdf->set_paper('A4', 'portrait');
$dompdf->set_option('isPhpEnabled', true);

// Realizar la consulta MySQL para obtener los datos de las facturas
$conexion = new PDO("mysql:host=localhost;dbname=ventas", "root", "");

$idCoordinador = 6;

$stmt = $conexion->prepare("SELECT * FROM pedidos WHERE id_coordinador = :idCoordinador");
$stmt->bindParam(':idCoordinador', $idCoordinador);
$stmt->execute();

$facturas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Calcular la cantidad de facturas obtenidas
$cantidadFacturas = count($facturas);

// Generar el contenido HTML para las facturas
$html = '
<html>
<head>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/css/bootstrap.min.css">
    <style>
        /* Estilos CSS personalizados */
        .factura {
            font-family: Arial, sans-serif;
            padding: 20px;
            border: 1px solid #ccc;
            margin-bottom: 20px;
            width: 100%;
        }
        
        .factura h1 {
            text-align: center;
            margin-bottom: 10px;
        }
        
        .factura .info {
            margin-bottom: 10px;
        }
        
        .factura .info span {
            font-weight: bold;
        }
        
        .factura .items {
            border-collapse: collapse;
            width: 100%;
        }
        
        .factura .items th,
        .factura .items td {
            border: 1px solid #ccc;
            padding: 10px;
        }
        
        .factura .total {
            margin-top: 10px;
            text-align: right;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <!-- Contenido del PDF -->
    <div class="container">
';

// Generar el contenido HTML para cada factura
for ($i = 0; $i < $cantidadFacturas; $i += 2) {
    $factura1 = $facturas[$i];
    $factura2 = null;
    
    if ($i + 1 < $cantidadFacturas) {
        $factura2 = $facturas[$i + 1];
    }
    
    $html .= '
    <div class="row">
        <div class="col-lg-6">
            <div class="factura">
                <h1>Factura ' . $factura1['codigo'] . '</h1>
                
                <div class="info">
                    <span>Número: ' . $factura1['codigo'] . '</span><br>
                    <span>Cliente: ' . $factura1['codigo'] . '</span><br>
                </div>
                
                <!-- Contenido de la factura -->
                
                <div class="total">
                    Total: ' . $factura1['codigo'] . '
                </div>
            </div>
        </div>';
    
    if ($factura2) {
        $html .= '
        <div class="col-lg-6">
            <div class="factura">
                <h1>Factura ' . $factura2['codigo'] . '</h1>
                
                <div class="info">
                    <span>Número: ' . $factura2['codigo'] . '</span><br>
                    <span>Cliente: ' . $factura2['codigo'] . '</span><br>
                </div>
                
                <!-- Contenido de la factura -->
                
                <div class="total">
                    Total: ' . $factura2['codigo'] . '
                </div>
            </div>
        </div>';
    }
    
    $html .= '</div>'; // Cerrar el row
}

$html .= '
    </div>
</body>
</html>';
echo $html;
// Agregar el contenido HTML al documento PDF
$dompdf->loadHtml($html);
$dompdf->render();

// Obtener el contenido PDF generado
$pdf_content = $dompdf->output();

// Guardar el archivo PDF en el disco o realizar alguna otra acción con él
file_put_contents('facturas.pdf', $pdf_content);
?>
