<?php
require_once 'autoload.inc.php';
require_once "../../modelos/conexion.php";
mb_internal_encoding("UTF-8");

use Dompdf\Dompdf;

$dompdf = new Dompdf();

$html = '<html>
<head>
<style>
.page {
    width: 100%;
    height: 100%;
    display: flex;
    flex-wrap: wrap;
    page-break-after: always;
}

.box {
    width: 50%;
    height: 50%;
    box-sizing: border-box;
    border: 1px solid #000;
    padding: 10px;
}

.invoice {
    margin-bottom: 10px;
    padding: 5px;
    background-color: #f5f5f5;
    font-size: 14px;
    height: 100px;
}

.invoice h2 {
    font-size: 14px;
    margin-top: 0;
}

.invoice p {
    margin: 3px 0;
}

table {
    width: 100%;
    border-collapse: collapse;
    font-size: 12px;
}

table th, table td {
    border: 1px solid #000;
    padding: 3px;
}

.company-info {
    float: left;
    margin-right: 20px;
}

.hotel-info {
    overflow: hidden;
}

.hotel-details {
    float: right;
}

.inline-p {
    display: inline;
    margin: 0;
    padding: 0;
    margin-right: 10px;
}
</style>
</head>
<body>
';

$conn = Conexion::obtenerConexion();
$conn->set_charset("utf8");
$duplicado = false;

if ($conn->connect_error) {
    die('Error de conexión a la base de datos: ' . $conn->connect_error);
}

$id_coordinador = Conexion::decryption($_GET["coordinador"]);

$sql = 'SELECT pedidos.id AS id_pedido, pedidos.nro_pedido, pedidos.importe_pago, pedidos.importe_total, pedidos.importe_debe, pedidos.fecha AS fecha_pedido, coordinadores.nombre AS coordinador_nombre,
coordinadores.fecha_entrega as fecha_entrega, pedidos.fecha as fecha_pedido,pedidos.nombre_pax,
pedidos.nro_habitacion, usuarios.nombre as nombre_vendedor,
empresas.nombre AS empresa_nombre, hoteles.nombre AS hotel_nombre
        FROM pedidos
        LEFT JOIN coordinadores ON pedidos.id_coordinador = coordinadores.id
        LEFT JOIN empresas ON coordinadores.id_empresa = empresas.id
        LEFT JOIN hoteles ON coordinadores.id_hotel = hoteles.id
        LEFT JOIN usuarios ON usuarios.id = pedidos.id_vendedor
        WHERE pedidos.cerrado = 1 AND pedidos.anulado IS NULL AND NOT pedidos.editando is null AND coordinadores.id = ' . $id_coordinador;

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $invoices = [];

    while ($row = $result->fetch_assoc()) {
        $invoice = [
            'id' => $row['id_pedido'],
            'fecha_pedido' => date('d M Y', strtotime($row['fecha_pedido'])),
            'coordinator' => utf8_decode($row['coordinador_nombre']),
            'company' => utf8_decode($row['empresa_nombre']),
            'hotel' => utf8_decode($row['hotel_nombre']),
            'vendedor' => utf8_decode($row['nombre_vendedor']),
            'fecha_entrega' => date('d M Y', strtotime($row['fecha_entrega'])),
            'nombre_pax' => utf8_decode($row['nombre_pax']),
            'nro_habitacion' => utf8_decode($row['nro_habitacion']),
            'importe_pago' => $row['importe_pago'],
            'importe_total' => $row['importe_total'],
            'importe_debe' => $row['importe_debe'],
            'nro_pedido' => $row['nro_pedido'],
            'items' => []
        ];

        $itemsSql = 'SELECT pedidos_detalle.cantidad, productos.descripcion, productos.precio_venta
                     FROM pedidos_detalle
                     LEFT JOIN productos ON pedidos_detalle.id_producto = productos.id
                     WHERE pedidos_detalle.id_pedido = ' . $row['id_pedido'];
        $itemsResult = $conn->query($itemsSql);

        while ($itemRow = $itemsResult->fetch_assoc()) {
            $invoice['items'][] = [
                'quantity' => $itemRow['cantidad'],
                'description' => utf8_decode(strtoupper($itemRow['descripcion'])),
                'price' => $itemRow['precio_venta']
            ];
        }

        $invoices[] = $invoice;
    }

    // EMPIEZA una página
    $html .= '<div class="page">';

    foreach ($invoices as $i => $invoice) {
        $html .= '<div class="box">
                    <div class="invoice">
                        <div class="company-info">
                            <p>Fecha Pedido: <strong>' . $invoice['fecha_pedido'] . '</strong></p>    
                            <p>Fecha Entrega: <strong>' . $invoice['fecha_entrega'] . '</strong></p>  
                            <p>Empresa: <strong>' . $invoice['company'] . '</strong></p>
                        </div>  
                        <div class="hotel-info">
                            <div class="hotel-details">
                                <p>Hotel: <strong>' . $invoice['hotel'] . '</strong></p>
                                <p>Coordinador: <strong>' . $invoice['coordinator'] . '</strong></p>
                                <p>Pax: <strong>' . $invoice['nombre_pax'] . '</strong></p>
                                <p>Hab.: ' . $invoice['nro_habitacion'] . '</p>
                            </div>            
                        </div>                     
                    </div>
                    <br><br>
                    <table>
                        <thead>
                            <tr>
                                <th style="text-align:center;">Cantidad</th>
                                <th>Descripción</th>
                            </tr>
                        </thead>
                        <tbody>';

        foreach ($invoice['items'] as $item) {
            $html .= '<tr>
                        <td style="text-align:center;">' . $item['quantity'] . '</td>
                        <td>' . mb_convert_encoding(strtoupper($item['description']), 'UTF-8', 'ISO-8859-1') . '</td>
                      </tr>';
        }

        $html .= '</tbody></table><br></div>';

        // Salto de página cada 4 pedidos
        if (($i + 1) % 4 === 0 && ($i + 1) < count($invoices)) {
            $html .= '</div><div class="page">';
        }
    }

    // Cierra última página
    $html .= '</div></body></html>';

    echo $html;

    /*$dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    $dompdf->stream('invoices.pdf', ['Attachment' => false]);*/
} else {
    echo 'No se encontraron notas de pedido.';
}

$conn->close();
?>
<script>
function printPage() {
  window.print();
}
</script>
