<?php
// Requerir la librería Dompdf
require_once 'autoload.inc.php';
require_once "../../modelos/conexion.php";
mb_internal_encoding("UTF-8");

use Dompdf\Dompdf;

// Crear una instancia de Dompdf
$dompdf = new Dompdf();

// Generar el contenido HTML del PDF
$html = '<html>
<head>
<style>
.page {
    width: 100%;
    display: flex;
    flex-wrap: wrap;
    page-break-after: always; /* Forzar salto de página después de cada conjunto de 4 recuadros */
}

.box {
    width: 50%; /* 2 columnas */
    height: 50%; /* 2 filas */
    box-sizing: border-box;
    border: 1px solid #000;
    padding: 10px;
    page-break-inside: avoid; /* Evita que el recuadro se divida entre páginas */
}

.invoice {
    margin-bottom: 10px;
    padding: 5px;
    background-color: #f5f5f5;
    font-size: 14px;
    height: 100px;
}

.invoice h2 {
    font-size: 14px;
    margin-top: 0;
}

.invoice p {
    margin: 3px 0;
}

table {
    width: 100%;
    border-collapse: collapse;
    font-size: 12px;
}

table th, table td {
    border: 1px solid #000;
    padding: 3px;
}

.company-info, .hotel-info {
    float: left;
    margin-right: 20px;
    width: 100%; /* Asegura que se mantenga en una sola fila */
    display: inline-block;
    text-align: left;
}

.hotel-info {
    margin-top: 10px;
}

.inline-p {
    display: inline;
    margin: 0;
    padding: 0;
    margin-right: 10px;
}
</style>
</head>
<body>';

$conn = Conexion::obtenerConexion();
$conn->set_charset("utf8");
$duplicado = false; // Imprime por duplicado cada nota de pedido

// Verificar la conexión
if ($conn->connect_error) {
    die('Error de conexión a la base de datos: ' . $conn->connect_error);
}

// Obtener el ID del coordinador deseado
$id_coordinador = Conexion::decryption($_GET["coordinador"]); // Reemplazar con el ID del coordinador deseado

// Consulta para obtener los invoices desde la tabla "pedidos"
$sql = 'SELECT pedidos.id AS id_pedido, pedidos.nro_pedido, pedidos.importe_pago, pedidos.importe_total, pedidos.importe_debe, pedidos.fecha AS fecha_pedido, coordinadores.nombre AS coordinador_nombre,
coordinadores.fecha_entrega as fecha_entrega, pedidos.fecha as fecha_pedido,pedidos.nombre_pax,
pedidos.nro_habitacion, usuarios.nombre as nombre_vendedor,
empresas.nombre AS empresa_nombre, hoteles.nombre AS hotel_nombre
        FROM pedidos
        LEFT JOIN coordinadores ON pedidos.id_coordinador = coordinadores.id
        LEFT JOIN empresas ON coordinadores.id_empresa = empresas.id
        LEFT JOIN hoteles ON coordinadores.id_hotel = hoteles.id
        LEFT JOIN usuarios ON usuarios.id = pedidos.id_vendedor
        WHERE pedidos.cerrado = 1 AND pedidos.anulado IS NULL AND NOT pedidos.editando is null AND coordinadores.id = ' . $id_coordinador;
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $invoices = array();

    // Obtener los datos de los invoices
    while ($row = $result->fetch_assoc()) {
        $invoice = array(
            'id' => $row['id_pedido'],
            'fecha_pedido' => date('d M Y', strtotime($row['fecha_pedido'])),
            'coordinator' => utf8_decode($row['coordinador_nombre']),
            'company' => utf8_decode($row['empresa_nombre']),
            'hotel' => utf8_decode($row['hotel_nombre']),
            'vendedor' => utf8_decode($row['nombre_vendedor']),
            'fecha_entrega' => date('d M Y', strtotime($row['fecha_entrega'])),
            'nombre_pax' => utf8_decode($row['nombre_pax']),
            'nro_habitacion' => utf8_decode($row['nro_habitacion']),
            'importe_pago' => $row['importe_pago'],
            'importe_total' => $row['importe_total'],
            'importe_debe' => $row['importe_debe'],
            'nro_pedido' => $row['nro_pedido'],
            'items' => array()
        );

        // Consulta para obtener los items del invoice desde las tablas "pedidos_detalle" y "productos"
        $itemsSql = 'SELECT pedidos_detalle.cantidad, productos.descripcion, productos.precio_venta
                     FROM pedidos_detalle
                     LEFT JOIN productos ON pedidos_detalle.id_producto = productos.id
                     WHERE pedidos_detalle.id_pedido = ' . $row['id_pedido'];
        $itemsResult = $conn->query($itemsSql);

        while ($itemRow = $itemsResult->fetch_assoc()) {
            $item = array(
                'quantity' => $itemRow['cantidad'],
                'description' => utf8_decode(strtoupper($itemRow['descripcion'])),
                'price' => $itemRow['precio_venta']
            );

            $invoice['items'][] = $item;
        }

        $invoices[] = $invoice;
    }

    // Paginación: Mostrar 4 pedidos por página
    $invoicesPerPage = 4;
    $totalInvoices = count($invoices);
    $totalPages = ceil($totalInvoices / $invoicesPerPage);

    for ($currentPage = 1; $currentPage <= $totalPages; $currentPage++) {
        $html .= '<div class="page">';

        $startIndex = ($currentPage - 1) * $invoicesPerPage;
        $endIndex = $startIndex + $invoicesPerPage;
        $pageInvoices = array_slice($invoices, $startIndex, $endIndex);

        foreach ($pageInvoices as $index => $invoice) {
            $boxIndex = ($index % 4) + 1;
        
            $html .= '<div class="box box-' . $boxIndex . '">
                        <div class="invoice">
                            <div class="company-info">
                                <p>Fecha Pedido: <strong>' . $invoice['fecha_pedido'] . '</strong> | 
                                   Fecha Entrega: <strong>' . $invoice['fecha_entrega'] . '</strong> | 
                                   Empresa: <strong>' . utf8_decode($invoice['company']) . '</strong></p>
                            </div>  
                            <div class="hotel-info">
                                <p>Hotel: <strong>' . utf8_decode($invoice['hotel']) . '</strong> | 
                                   Coordinador: <strong>' . utf8_decode($invoice['coordinator']) . '</strong> | 
                                   Pax: <strong>' . utf8_decode($invoice['nombre_pax']) . '</strong> | 
                                   Hab.: ' . $invoice['nro_habitacion'] . '</p>
                            </div>
                        </div>
                        <br><br>
                        <table class="invoice-table">
                            <thead>
                                <tr>
                                    <th style="text-align:center;">Cantidad</th>
                                    <th>Descripción</th>
                                </tr>
                            </thead>
                            <tbody>';

            $maxRowsToShow = 15; // Establece el número máximo de filas a mostrar

            $fontSize = (count($invoice['items']) > $maxRowsToShow) ? 'font-size: 8px;' : 'font-size: 12px;'; // Establece el tamaño de la fuente
        
            foreach ($invoice['items'] as $item) {
                $html .= '<tr>
                            <td style="text-align:center; ' . $fontSize . '">' . $item['quantity'] . '</td>
                            <td style="' . $fontSize . '">' . mb_convert_encoding(strtoupper($item['description']), 'UTF-8', 'ISO-8859-1') . '</td>
                          </tr>';
            }
        
            $html .= '</tbody>
                      </table><br>';

            $html .= '</div>';
        }

        $html .= '</div>'; // Cerrar la página
    }

    // Cerrar el cuerpo del HTML
    $html .= '</body>
            </html>';

    // Mostrar el HTML en el navegador
    echo $html;

} else {
    echo 'No se encontraron notas de pedido.';
}

$conn->close();
?>
<script>
function printPage() {
  window.print();
} 
</script>
