<?php
require('fpdf.php');

// Clase extendida de FPDF para crear una factura
class Invoice extends FPDF
{
    // Cabecera de página
    function Header()
    {
        // Logo (opcional)
        //$this->Image('logo.png',10,6,30);
        
        // Títulos de la factura
        $this->SetFont('Arial','B',15);
        $this->Cell(190,10,'Comprobante',0,0,'C');
        $this->Ln(20);
    }
    
    // Pie de página
    function Footer()
    {
        // Información de la empresa (opcional)
        $this->SetY(-15);
        $this->SetFont('Arial','',8);
        $this->Cell(0,10,'Empresa Frantom | xxxxxxxxx | Teléfono: xxxxxxx',0,0,'C');
    }
    
    // Crear factura
    function createInvoice($customer, $products)
    {
        // Información del cliente
        $this->SetFont('Arial','B',12);
        $this->Cell(50,10,'Coordinador:',0,0);
        $this->SetFont('Arial','',12);
        $this->Cell(0,10,$customer['nombre'],0,1);
        $this->Cell(50,10,'Dirección:',0,0);
        $this->SetFont('Arial','',12);
        $this->Cell(0,10,$customer['direccion'],0,1);
        $this->Ln(10);
        
        // Encabezado de la tabla de productos
        $this->SetFont('Arial','B',12);
        $this->Cell(40,10,'Producto',1,0,'C');
        $this->Cell(40,10,'Cantidad',1,0,'C');
        $this->Cell(40,10,'Precio Unitario',1,0,'C');
        $this->Cell(40,10,'Total',1,1,'C');
        
        // Detalles de los productos
        $this->SetFont('Arial','',12);
        foreach($products as $product) {
            $this->Cell(40,10,$product['nombre'],1,0);
            $this->Cell(40,10,$product['cantidad'],1,0,'C');
            $this->Cell(40,10,$product['precio'],1,0,'C');
            $this->Cell(40,10,$product['cantidad'] * $product['precio'],1,1,'C');
        }
        
        // Total de la factura
        $total = array_sum(array_column($products, 'cantidad', 'precio'));
        $this->SetFont('Arial','B',12);
        $this->Cell(160,10,'Total:',1,0,'R');
        $this->SetFont('Arial','',12);
        $this->Cell(40,10,'$' . $total,1,1,'C');
    }
}

// Datos de ejemplo
$customer = array(
    'nombre' => 'Cliente Ejemplo',
    'direccion' => 'Dirección de Ejemplo'
);

$products = array(
    array('nombre' => 'Producto 1', 'cantidad' => 2, 'precio' => 10),
    array('nombre' => 'Producto 2', 'cantidad' => 3, 'precio' => 15),
    array('nombre' => 'Producto 3', 'cantidad' => 1, 'precio' => 20)
);

// Crear instancia de la clase Invoice
$pdf = new Invoice();

// Crear página
$pdf->AddPage();

// Generar factura
$pdf->createInvoice($customer, $products);

// Salida del PDF
$pdf->Output();
?>
