<?php 

require('fpdf.php');
require_once "../../modelos/conexion.php";

// Crear la clase extendida de FPDF
class PDF extends FPDF
{
  // Variables para la división de la página
  private $division = 0;

  // Cabecera de página
  function Header()
  {
    // Logo o título de la factura/boleto
    $this->SetFont('Arial', 'B', 18);
    $this->Cell(80);
    //$this->Cell(30, 10, 'Factura', 1, 0, 'C');
    $this->Ln(20);
  }

  // Pie de página
  function Footer()
  {
    // Número de página
    $this->SetY(-15);
    $this->SetFont('Arial', 'I', 8);
    $this->Cell(0, 10, 'Página ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
  }

  // Generar un boleto o remito
  function GenerarBoleto($pedido)
  {
    // Cálculo de coordenadas de la división en la hoja
    $x = (($this->division - 1) % 2) * 105; // Coordenada X (0 o 105)
    $y = (int)(($this->division - 1) / 2) * 140; // Coordenada Y (0, 140, 280, ...)

    // Establecer posición en la página
    $this->SetXY($x, $y);

    // Remarcar división con líneas
    $this->Rect($x, $y, 105, 140);

    // Contenido del boleto
    $this->SetFont('Arial', 'B', 12);
    $this->SetXY($x + 5, $y + 5); // Ajustar posición para el título
    $this->Cell(0, 10, 'Nota de Pedido', 0, 1, 'L');
    $this->Ln(10);

    // Información del pedido
    $this->SetFont('Arial', '', 10);
    $this->SetX($x + 5); // Ajustar posición para la información del pedido
    $this->Cell(0, 10, 'ID Pedido: ' . $pedido['id'], 0, 1);
    $this->Cell(0, 10, 'Fecha: ' . $pedido['fecha'], 0, 1);

    // Decodificar el JSON embebido
    $productos = json_decode($pedido['productos'], true);

    // Verificar si la decodificación fue exitosa
    if (!empty($productos)) {
      foreach ($productos as $producto) {
        $this->SetX($x + 5); // Ajustar posición para cada producto y cantidad
        $this->Cell(0, 10, 'Producto: ' . $producto['descripcion'], 0, 1);
        $this->SetX($x + 5);
        $this->Cell(0, 10, 'Cantidad: ' . $producto['cantidad'], 0, 1);
      }
    } else {
      $this->Cell(0, 10, 'Error en el formato de productos.', 0, 1);
    }

    $this->Ln(10);
  }

  // Agregar una nueva página con la división adecuada
  function AgregarPagina()
  {
    $this->AddPage();
    $this->division = 0;
  }
}

// Crear una instancia de la clase PDF
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();

// Conexión a la base de datos
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "ventas";

$conn = new mysqli($servername, $username, $password, $dbname);
$conn->query("SET NAMES 'utf8'");

// Verificar la conexión
if ($conn->connect_error) {
  die("Error de conexión: " . $conn->connect_error);
}

// ID del coordinador específico
$idCoordinador = 2;

// Consulta SQL con filtro por coordinador específico
$sql = "SELECT * FROM pedidos WHERE id_coordinador = $idCoordinador";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
  // Iterar sobre los pedidos
  while ($row = $result->fetch_assoc()) {
    /*if ($pdf->division % 4 == 0 && $pdf->division > 0) {
      $pdf->AgregarPagina();
    }

    $pdf->division++;*/
    $pdf->GenerarBoleto($row);
  }
} else {
  $pdf->Cell(0, 10, 'No se encontraron resultados.', 0, 1);
}

$conn->close();

// Salida del PDF
$pdf->Output();

?>