<?php
require('fpdf.php');

// Conexión a la base de datos
$servername = "localhost";
$username = "root";
$password = "root";
$dbname = "pedidos_app";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Obtener la lista de coordinadores
$sql_coordinadores = "SELECT c.id, c.nombre AS nombre_coordinador, e.nombre AS nombre_empresa
                      FROM coordinadores c
                      LEFT JOIN empresas e ON c.id_empresa = e.id
                      ORDER BY c.id";

$result_coordinadores = $conn->query($sql_coordinadores);

// Generar el reporte en PDF
$pdf = new FPDF();

$primer_pagina = true; // Variable para controlar si es la primera página o no

while ($row_coordinador = $result_coordinadores->fetch_assoc()) {
    // Obtener los pedidos del día de hoy para el coordinador actual
    $hoy = date("Y-m-d");
    $coordinador_id = $row_coordinador['id'];
    $sql_pedidos = "SELECT p.id AS nro_pedido, p.nombre_pax AS pasajero, p.nro_habitacion AS habitacion, p.importe_total AS total_pedido
                    FROM pedidos p
                    WHERE DATE(p.fecha) = '$hoy' AND p.id_coordinador = $coordinador_id
                    ORDER BY p.id";

    $result_pedidos = $conn->query($sql_pedidos);

    // Verificar si hay pedidos para el coordinador actual
    if ($result_pedidos->num_rows > 0) {
        // Agregar una nueva página
        $pdf->AddPage();

        // Mostrar el título en la parte superior
        if ($primer_pagina) {
            $pdf->SetFont('Arial', 'B', 16);
            $pdf->Cell(0, 10, 'Reporte de Pedidos Hoy', 0, 1, 'C');
            $pdf->Ln(10);
            $primer_pagina = false; // Cambiar el valor para las próximas páginas
        }

        // Mostrar los datos de empresa y coordinador
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(0, 10, 'Empresa: ' . utf8_decode($row_coordinador['nombre_empresa']), 0, 1, 'L');
        $pdf->Cell(0, 10, 'Coordinador: ' . utf8_decode($row_coordinador['nombre_coordinador']), 0, 1, 'L');
        $pdf->Ln(10);

        // Configurar el formato de la grilla
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->SetFillColor(0, 0, 0); // Color negro para el fondo de las celdas de las cabeceras
        $pdf->SetTextColor(255, 255, 255); // Color blanco para el texto de las cabeceras
        $pdf->Cell(30, 10, 'Nro. Pedido', 1, 0, 'C', true);
        $pdf->Cell(90, 10, 'Pasajero', 1, 0, 'C', true);
        $pdf->Cell(30, 10, utf8_decode('Habitación'), 1, 0, 'C', true);
        $pdf->Cell(40, 10, 'Total Pedido', 1, 1, 'C', true);

        $pdf->SetFont('Arial', '', 12);
        $pdf->SetFillColor(255, 255, 255); // Restaurar el color blanco para el fondo de las celdas de datos
        $pdf->SetTextColor(0, 0, 0); // Restaurar el color negro para el texto de las celdas de datos

        // Mostrar los pedidos en la grilla
        $contador_pedidos = 0; // Contador de pedidos por página
        $total_pedidos = 0; // Suma de todos los pedidos por página
        while ($row_pedido = $result_pedidos->fetch_assoc()) {
            $contador_pedidos++; // Incrementar el contador de pedidos por página
            $pdf->Cell(30, 10, $row_pedido['nro_pedido'], 1, 0, 'C');
            $pdf->Cell(90, 10, utf8_decode($row_pedido['pasajero']), 1, 0, 'C');
            $pdf->Cell(30, 10, $row_pedido['habitacion'], 1, 0, 'C');
            $pdf->Cell(40, 10, "$ " . $row_pedido['total_pedido'], 1, 1, 'C');

            $total_pedidos += $row_pedido['total_pedido']; // Sumar el total del pedido al totalizador
        }

        // Mostrar la cantidad de pedidos en la grilla actual
        $pdf->Cell(0, 10, 'Cantidad de Pedidos: ' . $contador_pedidos, 0, 1, 'R');

        // Mostrar el total de los pedidos por página
        $pdf->Cell(0, 10, 'Total Pedidos: $ ' . $total_pedidos, 0, 1, 'R');
    }
}

// Cerrar la conexión a la base de datos
$conn->close();

// Salida del PDF
$pdf->Output();
?>
