<?php
require('fpdf.php');
require_once "../../modelos/conexion.php";

class PDF extends FPDF
{
  function Header()
  {
    global $nombre_empresa, $nombre_coordinador, $fecha_entrega, $nombre_hotel, $telefono;

    // Título
    $this->SetFont('Arial', 'B', 16);
    $this->Cell(0, 20, 'Productos por Grupo', 0, 1, 'C');

    // Encabezado de la página
    $this->SetFont('Arial', 'B', 12);
    $this->Cell(0, 10, 'Hotel: ' . utf8_decode($nombre_hotel), 0, 1, 'L');
    $this->Cell(0, 10, 'Empresa: ' . utf8_decode($nombre_empresa), 0, 1, 'L');
    $this->Cell(0, 10, 'Coordinador: ' . utf8_decode($nombre_coordinador), 0, 1, 'L');
    $this->Cell(0, 10, 'Fecha Entrega: ' . strftime("%d %b %Y", strtotime($fecha_entrega)), 0, 1, 'L');
    $this->Cell(0, 10, 'Telefono: ' . $telefono, 0, 1, 'L');
    $this->Ln(10);
  }

  function Footer()
  {
    // Pie de página
    $this->SetY(-15);
    $this->SetFont('Arial', 'I', 8);
    $this->Cell(0, 10, 'Pag. ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
  }

  function generarReporte($data)
  {
    // Configuración de la página
    $this->AddPage();
    $this->SetFont('Arial', 'B', 10);

    // Encabezado de la tabla
    $this->SetFillColor(0, 0, 0); // Color de fondo negro
    $this->SetTextColor(255, 255, 255); // Color de texto blanco
    $this->Cell(120, 10, 'Producto', 1, 0, 'C', true); // Con fondo negro
    $this->Cell(60, 10, 'Cantidad', 1, 1, 'C', true); // Con fondo negro

    // Contenido de la tabla
    $this->SetFont('Arial', '', 10);
    $this->SetTextColor(0); // Restaurar color de texto negro
    $totalCantidad = 0; // Variable para almacenar la suma de las cantidades

    foreach ($data as $row) {
      $this->Cell(120, 10, utf8_decode($row['producto']), 1, 0, 'L');
      $this->Cell(60, 10, $row['cantidad_total'], 1, 1, 'C');
      $totalCantidad += $row['cantidad_total']; // Sumar la cantidad actual al total
    }

    // Agregar el tfoot con la suma total de cantidades
    $this->Cell(120, 10, 'Total productos:', 1, 0, 'R', false);
    $this->Cell(60, 10, $totalCantidad, 1, 1, 'C', false);
  }
}

// Crear una instancia del objeto PDF
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->SetFont('Arial', '', 10);

// Obtener el ID del coordinador deseado
$id_coordinador = Conexion::decryption($_GET["coordinador"]);

// Establecer la conexión a la base de datos
$conn = Conexion::conectar();

if ($conn) {
  // Consultar los datos de la base de datos
  $sql = "SET NAMES 'utf8'";
  $conn->query($sql);

  // Consultar los datos de la base de datos
  $sql = "SELECT e.nombre AS nombre_empresa, c.nombre AS nombre_coordinador, c.fecha_entrega AS fecha_entrega, c.telefono,
               pr.descripcion AS producto, SUM(pd.cantidad) AS cantidad_total, h.nombre AS nombre_hotel
            FROM pedidos p
            LEFT JOIN coordinadores c ON p.id_coordinador = c.id
            LEFT JOIN empresas e ON c.id_empresa = e.id
            LEFT JOIN hoteles h ON c.id_hotel = h.id
            LEFT JOIN pedidos_detalle pd ON p.id = pd.id_pedido
            LEFT JOIN productos pr ON pd.id_producto = pr.id
            WHERE p.cerrado=1 and c.id = $id_coordinador and not p.editando is null and p.anulado IS NULL
            GROUP BY pr.id
            ORDER BY cantidad_total DESC, producto ASC";
  $result = $conn->query($sql);
  $data = array();

  foreach ($result as $key => $value) {
    $data[] = $value;
    $nombre_empresa = $value['nombre_empresa'];
    $nombre_coordinador = $value['nombre_coordinador'];
    $nombre_hotel = $value['nombre_hotel'];
    $fecha_entrega = $value['fecha_entrega'];
    $telefono = $value['telefono'];
  }

  // Generar el reporte con los datos
  $pdf->generarReporte($data);

  // Crear directorio base "reportes" si no existe
  $baseDir = '../../reportes';
  if (!is_dir($baseDir)) {
    mkdir($baseDir, 0777, true);
  }

  // Crear subdirectorio para el ID del coordinador si no existe
  $coordinadorDir = $baseDir . '/' . $id_coordinador;
  if (!is_dir($coordinadorDir)) {
    mkdir($coordinadorDir, 0777, true);
  }

  // Definir la ruta completa del archivo
  //$filename = $coordinadorDir . '/reporte_Productos por Grupo' . date('Ymd_His') . '.pdf';
  $filename = $coordinadorDir . '/reporte_Productos_por_Grupo.pdf';
  // Guardar el archivo en el servidor
  $pdf->Output('F', $filename);

  // También abrirlo en una ventana del navegador
  $pdf->Output();

  // Cerrar la conexión a la base de datos
  Conexion::desconectar($conn);

  // Mensaje opcional
  echo "PDF generado y guardado en el servidor en: " . $filename;
} else {
  echo "Error de conexión a la base de datos.";
}
