<?php

// Motrar todos los errores de PHP
error_reporting(-1);

// No mostrar los errores de PHP
error_reporting(0);

// Motrar todos los errores de PHP
error_reporting(E_ALL);

// Motrar todos los errores de PHP
ini_set('error_reporting', E_ALL);

require('fpdf.php');
require_once "../../modelos/conexion.php";

class PDF extends FPDF
{
    function Header()
    {
        global $nombre_empresa, $nombre_coordinador, $fecha_entrega, $nombre_hotel;

        // Título
        $this->SetFont('Arial', 'B', 16);
        $this->Cell(0, 20, 'Productos agrupados por Coordinador y Pedido', 0, 1, 'C');

        // Encabezado de la página
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 10, 'Hotel: ' . utf8_decode($nombre_hotel), 0, 1, 'L');
        $this->Cell(0, 10, 'Empresa: ' . utf8_decode($nombre_empresa), 0, 1, 'L');
        $this->Cell(0, 10, 'Coordinador: ' . utf8_decode($nombre_coordinador), 0, 1, 'L');
        $this->Cell(0, 10, 'Fecha Entrega: ' . date('d M Y', strtotime($fecha_entrega)), 0, 1, 'L');
        $this->Ln(10);
    }

    function Footer()
    {
        // Pie de página
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Pag. ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }
}

// Crear una instancia del objeto PDF
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->SetFont('Arial', '', 10);

// Obtener el ID del coordinador deseado
$id_coordinador = Conexion::decryption($_GET["coordinador"]); // Reemplazar con el ID del coordinador deseado

// Establecer la conexión a la base de datos
$conn = Conexion::conectar();
// Verificar la conexión

// Consulta SQL para obtener los pedidos con los productos del coordinador especificado
$sql = "SELECT p.id AS id_pedido, p.productos, p.nro_pedido, p.codigo, p.fecha, c.nombre AS coordinador, 
h.nombre as nombre_hotel, e.nombre as nombre_empresa, p.fecha_entrega
        FROM pedidos p
        LEFT JOIN coordinadores c ON p.id_coordinador = c.id
        LEFT JOIN hoteles h ON c.id_hotel = h.id
        LEFT JOIN empresas e ON c.id_empresa = e.id
        WHERE p.id_coordinador = $id_coordinador AND p.cerrado = 1 AND p.anulado IS NULL
        ORDER BY p.id";

// Ejecutar la consulta
$result = $conn->query($sql);

// Crear el objeto PDF
$pdf = new FPDF();

// Configurar la fuente y el tamaño
$pdf->SetFont('Arial', '', 12);

// Mostrar los pedidos en la grilla
$firstPage = true;
while ($row = $result->fetch(PDO::FETCH_ASSOC)) {

    $productos = json_decode($row["productos"]);

    // Cambio de pedido, generar una nueva página
    if (!isset($id_pedido) || $id_pedido !== $row['id_pedido']) {
        if (isset($id_pedido)) {
            $pdf->Cell(140, 10, 'Total del Pedido: ', 1, 0, 'R');
            $pdf->Cell(50, 10, '$' . number_format($total_pedido, 2), 1, 1, 'C');
        }

        // Inicializar los valores del nuevo pedido
        $id_pedido = $row['id_pedido'];
        $total_pedido = 0;

        // Generar una nueva página
        $pdf->AddPage();

        // Mostrar el título del reporte en la primera página
        if ($firstPage) {
            $pdf->SetFont('Arial', 'B', 20); // Cambiar el tamaño y estilo de la fuente
            $pdf->Cell(0, 20, 'Detalle de pedidos con importes', 0, 1, 'C'); // Aumentar la altura de la celda
            $pdf->Ln(10);
            $firstPage = false;
        }

        // Mostrar los datos del pedido actual
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(0, 10, 'Empresa: ' . utf8_decode($row['nombre_empresa']), 0, 1, 'L');
        $pdf->Cell(0, 10, 'Hotel: ' . utf8_decode($row['nombre_hotel']), 0, 1, 'L');
        $pdf->Cell(0, 10, 'Coordinador: ' . utf8_decode($row['coordinador']), 0, 1, 'L');
        $pdf->Cell(0, 10, 'Fecha Entrega: ' . date('d M Y', strtotime(utf8_decode($row['fecha_entrega']))), 0, 1, 'L');
        $pdf->Cell(0, 10, 'Nro de Pedido: ' . $row['nro_pedido'], 0, 1, 'L');
        $pdf->Ln(5);

        // Encabezados de la grilla
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(95, 10, 'Producto', 1, 0, 'C');
        $pdf->Cell(15, 10, 'Cant.', 1, 0, 'C');
        $pdf->Cell(30, 10, 'Precio U.', 1, 0, 'C');
        $pdf->Cell(20, 10, '% Desc.', 1, 0, 'C');
        $pdf->Cell(30, 10, 'Importe', 1, 1, 'C');
    }

    foreach ($productos as $key => $value) {

        $descuento = ($value->descuento == null || $value->descuento == '') ? 0 : $value->descuento;
        // Mostrar los detalles del pedido actual
        $pdf->SetFont('Arial', '', 12);
        $pdf->Cell(95, 10, utf8_decode($value->descripcion), 1, 0, 'L');
        $pdf->Cell(15, 10, $value->cantidad, 1, 0, 'C');
        $pdf->Cell(30, 10, '$' . number_format($value->precio, 2), 1, 0, 'R');
        $pdf->Cell(20, 10, ' % ' . $descuento, 1, 0, 'C');
        $pdf->Cell(30, 10, '$' . number_format($value->total, 2), 1, 1, 'R');
        $subtotal = $value->total;

        // Actualizar el total del pedido
        $total_pedido += $subtotal;
    }
}

// Mostrar el total del último pedido
if (isset($id_pedido)) {
    $pdf->Cell(140, 10, 'Total del Pedido: ', 1, 0, 'R');
    $pdf->Cell(50, 10, '$' . number_format($total_pedido, 2), 1, 1, 'C');
}

// Cerrar la conexión a la base de datos
$conn = null;

// Salida del PDF
$pdf->Output();
