<?php
require_once('tcpdf_include.php');
require_once "../../../modelos/conexion.php";

class Invoice extends TCPDF {
    function Header() {
        // Configurar la cabecera del invoice (opcional)
    }

    function Footer() {
        // Configurar el pie de página del invoice (opcional)
    }

    function generateInvoice($data) {
        // Generar el contenido del invoice
        $this->SetFont('helvetica', '', 12);
        $this->Cell(0, 10, $data['invoice_number'], 0, 1, 'C');
        // Agrega aquí los campos que deseas mostrar en el invoice
    }
}

// Conexión a la base de datos
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "ventas";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Consulta a la base de datos
$sql = "SELECT * FROM pedidos WHERE id_coordinador = 6";
$result = $conn->query($sql);

// Crear una instancia de la clase Invoice
$pdf = new Invoice('P', 'mm', 'A4', true, 'UTF-8', false);

// Dividir la página en 4 partes
$pageWidth = $pdf->getPageWidth();
$pageHeight = $pdf->getPageHeight();
$sectionWidth = $pageWidth / 2;
$sectionHeight = $pageHeight / 2;

// Procesar los resultados de la consulta y generar los invoices
$i = 0;
while ($row = $result->fetch_assoc()) {
    // Obtener los datos del invoice
    $invoiceData = array(
        'invoice_number' => $row['id'], // Cambia esto según la estructura de tu base de datos
        // Agrega aquí los campos que deseas mostrar en el invoice
    );

    // Calcular las coordenadas de la sección actual
    $x = $i % 2 * $sectionWidth + 10;
    $y = floor($i / 2) * $sectionHeight + 10;

    // Agregar una nueva página si es necesario
    if ($i > 0 && $i % 4 === 0) {
        $pdf->AddPage();
    }

    // Establecer la posición actual en la sección actual
    $pdf->SetXY($x, $y);

    // Generar invoice en la sección actual
    $pdf->generateInvoice($invoiceData);

    $i++;
}

// Salida del PDF
$pdf->Output('invoices.pdf', 'D');
