<?php

require_once "conexion.php";
require_once "auditorias.class.php";

class ModeloCoordinadores
{

    /*=============================================
	CREAR COORDINADOR
	=============================================*/
    static public function mdlIngresarCoordinador($tabla, $datos)
    {
        try {
            // Iniciar la transacción
            $link = Conexion::conectar();
            $link->beginTransaction();

            $stmt = $link->prepare("INSERT INTO $tabla(nombre, documento, telefono, id_hotel, id_empresa, fecha_entrega, fecha_alta) VALUES (:nombre, :documento, :telefono, :hotel, :empresa, :fecha_entrega, :fecha_alta)");

            $stmt->bindParam(":nombre", $datos["nombre"], PDO::PARAM_STR);

            if (!empty($datos["documento"])) {
                $stmt->bindParam(":documento", $datos["documento"], PDO::PARAM_STR);
            } else {
                $stmt->bindValue(":documento", null, PDO::PARAM_NULL);
            }
            $stmt->bindParam(":telefono", $datos["telefono"], PDO::PARAM_STR);
            $stmt->bindParam(":hotel", $datos["hotel"], PDO::PARAM_INT);
            $stmt->bindParam(":empresa", $datos["empresa"], PDO::PARAM_INT);
            $stmt->bindParam(":fecha_entrega", $datos["fecha_entrega"], PDO::PARAM_STR);
            $stmt->bindParam(":fecha_alta", $datos["fecha_alta"], PDO::PARAM_STR);

            if ($stmt->execute()) {
                // Confirmar la transacción si todas las consultas fueron exitosas
                $link->commit();
                Auditoria::escribirLog("Se insertó un nuevo coordinador: " . $datos["nombre"] . ' - fecha salida '. $datos["fecha_entrega"]);
                return true;
            } else {
                // Cancelar la transacción en caso de error
                $link->rollBack();
                $errorInfo = $stmt->errorInfo();
                echo "Error al ejecutar la consulta: " . $errorInfo[2];
                return false;
            }
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
            Auditoria::escribirLog("Error al guardar coordinador: " . $e->getMessage());
            
        } finally {
            if ($stmt) {
                $stmt->closeCursor();
            }
        }
    }


    /*=============================================
	MOSTRAR COORDINADORES
	=============================================*/
    static public function mdlMostrarCoordinadores($tabla, $item, $valor)
    {   
        $hoy = date("Y-m-d");
        try {
            if ($item != null) {
                $stmt = Conexion::conectar()->prepare("SELECT a.*, b.nombre as hotel, c.color, c.nombre as empresa FROM $tabla a LEFT JOIN hoteles b ON a.id_hotel = b.id LEFT JOIN empresas c ON a.id_empresa = c.id WHERE a.$item = :$item");
                $stmt->bindParam(":" . $item, $valor, PDO::PARAM_STR);
                $stmt->execute();
                return $stmt->fetch();
            } else {          
                $stmt = Conexion::conectar()->prepare("SELECT a.*, b.nombre AS empresa, c.nombre AS hotel FROM coordinadores a 
                LEFT JOIN empresas b ON a.id_empresa = b.id
                LEFT JOIN hoteles c ON a.id_hotel = c.id WHERE a.fecha_alta = '{$hoy}' AND cerrado IS NULL ORDER BY a.id DESC");
                $stmt->execute();
                return $stmt->fetchAll();
            }
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
        }
    }


    /*=============================================
	EDITAR COORDINADOR
	=============================================*/

    static public function mdlEditarCoordinador($tabla, $datos){
        $conexion = Conexion::conectar();
        $conexion->beginTransaction();
    
        try {
            $stmt = $conexion->prepare("UPDATE $tabla SET nombre = :nombre, documento = :documento, telefono = :telefono, id_hotel = :id_hotel, id_empresa = :id_empresa, fecha_entrega = :fecha_entrega  WHERE id = :id");
            $stmt->bindParam(":id", $datos["id"], PDO::PARAM_INT);
            $stmt->bindParam(":nombre", $datos["nombre"], PDO::PARAM_STR);
            $stmt->bindParam(":id_hotel", $datos["hotel"], PDO::PARAM_INT);
            $stmt->bindParam(":id_empresa", $datos["empresa"], PDO::PARAM_INT);
            $stmt->bindParam(":documento", $datos["documento"], PDO::PARAM_INT);
            $stmt->bindParam(":telefono", $datos["telefono"], PDO::PARAM_STR);
            $stmt->bindParam(":fecha_entrega", $datos["fecha_entrega"], PDO::PARAM_STR);
    
            if ($stmt->execute()) {
                $conexion->commit();
                // Log de auditoría
                Auditoria::escribirLog("Se editó coordinador con ID " . $datos["id"]);
                return true;
            } else {
                $conexion->rollBack();
                $errorInfo = $stmt->errorInfo();
                echo "Error al ejecutar la consulta: " . $errorInfo[2];
                Auditoria::escribirLog("Se editó coordinador con ID " . $errorInfo[2]);
                return false;
            }
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            $conexion->rollBack();
            echo "Error: " . $e->getMessage();
        }
    }
    


    /*=============================================
	ELIMINAR COORDINADOR
	=============================================*/

    static public function mdlEliminarCliente($tabla, $datos)
    {
        try {
            $stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE id = :id");
            $stmt->bindParam(":id", $datos, PDO::PARAM_INT);

            if ($stmt->execute()) {
                return "ok";
            } else {
                return "error";
            }
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
        } finally {
            if ($stmt) {
                $stmt->closeCursor();
            }
        }
    }


    /*=============================================
	ACTUALIZAR COORDINADOR
	=============================================*/

    static public function mdlActualizarCliente($tabla, $item1, $valor1, $valor)
    {
        try {
            $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE id = :id");
            $stmt->bindParam(":" . $item1, $valor1, PDO::PARAM_STR);
            $stmt->bindParam(":id", $valor, PDO::PARAM_STR);

            if ($stmt->execute()) {
                return "ok";
            } else {
                return "error";
            }
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
        } finally {
            if ($stmt) {
                $stmt->closeCursor();
            }
        }
    }

    /*=============================================
	CERRAR GRUPO
	=============================================*/
    static public function mdlCerrarGrupo($tabla, $datos)
    {
        try {
            // Iniciar la transacción
            $link = Conexion::conectar();
            $link->beginTransaction();

            // Actualizar los datos en la tabla principal (por ejemplo, tabla pedidos)
            $stmt_update = $link->prepare("UPDATE $tabla SET cerrado = :cerrado WHERE id = :id_coordinador");
            $stmt_update->bindParam(":cerrado", $datos["cerrado"], PDO::PARAM_INT);
            $stmt_update->bindParam(":id_coordinador", $datos["id_coordinador"], PDO::PARAM_INT);
        
            if (!$stmt_update->execute()) {
                $errorInfo = $stmt_update->errorInfo();
                echo "Error al ejecutar la consulta update pedido: " . $errorInfo[2];
                $link->rollBack();
                return false;
            }

            // Confirmar la transacción si todas las consultas fueron exitosas
            $link->commit();
            // Log de auditoría
            Auditoria::escribirLog("Se cerró grupo, coordinador con ID: " . $datos["id_coordinador"]);
            return true;
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
            $link->rollBack();
            return false;
        }
    }
}
