<?php

require_once "conexion.php";
require_once "auditorias.class.php";

class ModeloPedidos
{
    static public function mdlEditandoPedido($tabla, $pedido, $estado)
    {
        try {
            $link = Conexion::conectar();
            $link->beginTransaction();

            // Actualizar pedido
            $stmt_update = $link->prepare("UPDATE $tabla SET editando = :estado WHERE id = :id_pedido");
            $stmt_update->bindParam(":estado", $estado, PDO::PARAM_STR);
            $stmt_update->bindParam(":id_pedido", $pedido, PDO::PARAM_INT);

            if (!$stmt_update->execute()) {
                $errorInfo = $stmt_update->errorInfo();
                echo "Error al ejecutar la consulta update pedido: " . $errorInfo[2];
                $link->rollBack();
                return false;
            }

            // Confirmar la transacción si todas las consultas fueron exitosas
            $link->commit();
            return true;
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
            $link->rollBack();
            return false;
        }
    }

    static public function mdlTotalPedidos($tabla)
    {
        $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");
        $stmt->execute();
        return $stmt->fetchAll();
    }

    static public function mdlTotalPedidosByCoordinador($tabla, $coordinador)
    {
        $query = "SELECT
        (SELECT COUNT(*) FROM $tabla WHERE id_coordinador = $coordinador AND NOT anulado IS NULL) AS pedidos_anulados,
        (SELECT COUNT(*) FROM $tabla WHERE id_coordinador = $coordinador AND anulado IS NULL) AS pedidos_correctos,
        (SELECT COUNT(*) FROM $tabla WHERE id_coordinador = $coordinador AND cerrado IS NOT NULL) AS pedidos_cerrados,
        (SELECT COUNT(*) FROM $tabla WHERE id_coordinador = $coordinador AND cerrado IS NULL AND NOT anulado IS NULL) AS pedidos_pendientes,
        (SELECT COUNT(*) FROM $tabla WHERE id_coordinador = $coordinador) AS pedidos_total;";
        $stmt = Conexion::conectar()->prepare($query);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    /*=============================================
	MOSTRAR PEDIDOS
	=============================================*/
    static public function mdlMostrarPedidos($tabla, $item, $valor)
    {
        $stmt = null;

        try {
            if ($item != null) {
                $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY id ASC");
                $stmt->bindParam(":" . $item, $valor, PDO::PARAM_STR);
                $stmt->execute();
                return $stmt->fetch();
            } else {
                $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE (anulado is null or anulado = 0) ORDER BY id ASC");
                $stmt->execute();
                return $stmt->fetchAll();
            }
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
        } finally {
            if ($stmt) {
                $stmt->closeCursor();
            }
        }
    }

    /*=============================================
	MOSTRAR PEDIDOS POR VENDEDOR
	=============================================*/
    static public function mdlMostrarPedidosByVendedor($tabla, $item, $valor)
    {
        $stmt = null;
        $hoy = date("Y-m-d");
        try {
            if ($item != null) {
                $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item AND fecha = '{$hoy}' ORDER BY id ASC");
                $stmt->bindParam(":" . $item, $valor, PDO::PARAM_STR);
                $stmt->execute();
                return $stmt->fetchAll();
            }
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
        } finally {
            if ($stmt) {
                $stmt->closeCursor();
            }
        }
    }

    /*=============================================
	REGISTRO DE PEDIDOS
	=============================================*/
    //AGREGO PEDIDO DETALLE 
    static public function mdlIngresarPedido($tabla, $datos)
    {
        try {
            // Iniciar la transacción
            $link = Conexion::conectar();
            $link->beginTransaction();

            // Consultar el último número de pedido
            $hoy = date('Y-m-d');
            $coordinador = $datos["id_coordinador"];
            $stmtNumeroPedido = $link->prepare("SELECT MAX(nro_pedido) as ultimo_nro FROM $tabla WHERE id_coordinador = {$coordinador} AND fecha = '{$hoy}' AND anulado IS NULL;");
            $stmtNumeroPedido->execute();
            $ultimoNro = $stmtNumeroPedido->fetch(PDO::FETCH_ASSOC);
            $nuevoNro = $ultimoNro['ultimo_nro'] + 1;

            $stmt = $link->prepare("INSERT INTO $tabla(codigo, fecha, id_vendedor, id_coordinador, productos, importe_neto, importe_total, importe_pago, importe_debe ,descuento, fecha_entrega, nombre_pax, nro_habitacion, nro_pedido, cerrado, pago_en_hotel) 
        VALUES (:codigo, :fecha, :id_vendedor, :id_coordinador, :productos, :importe_neto, :importe_total, :importe_pago, :importe_debe, :descuento, :fecha_entrega, :nombre_pax, :nro_habitacion, :nro_pedido, :cerrado, :pago_en_hotel)");
            $stmt->bindParam(":nro_pedido", $nuevoNro, PDO::PARAM_INT);

            $stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_INT);
            $stmt->bindParam(":fecha", $datos["fecha_pedido"], PDO::PARAM_STR);
            $stmt->bindParam(":id_vendedor", $datos["id_vendedor"], PDO::PARAM_INT);
            $stmt->bindParam(":id_coordinador", $datos["id_coordinador"], PDO::PARAM_INT);
            $stmt->bindParam(":productos", $datos["productos"], PDO::PARAM_STR);
            $stmt->bindParam(":importe_neto", $datos["importe_neto"], PDO::PARAM_STR);
            $stmt->bindParam(":importe_total", $datos["importe_total"], PDO::PARAM_STR);
            $stmt->bindParam(":descuento", $datos["descuento"], PDO::PARAM_STR);
            $stmt->bindParam(":fecha_entrega", $datos["fecha_entrega"], PDO::PARAM_STR);
            $stmt->bindParam(":nombre_pax", $datos["nombre_pax"], PDO::PARAM_STR);
            $stmt->bindParam(":nro_habitacion", $datos["nro_habitacion"], PDO::PARAM_STR);
            $stmt->bindParam(":importe_pago", $datos["nuevo_total_pago"], PDO::PARAM_STR);
            $stmt->bindParam(":importe_debe", $datos["importe_debe"], PDO::PARAM_STR);
            $stmt->bindParam(":pago_en_hotel", $datos["pago_en_hotel"], PDO::PARAM_STR);
            $stmt->bindParam(":cerrado", $datos["cerrado"], PDO::PARAM_STR);

            if ($stmt->execute()) {
                // Obtener el ID del pedido insertado
                $id_pedido = $link->lastInsertId();

                // Insertar cada producto en la tabla pedido_detalle
                $productos = json_decode($datos["productos"], true);
                foreach ($productos as $producto) {

                    $stmt_detalle = $link->prepare("INSERT INTO pedidos_detalle(id_pedido, id_producto, cantidad) VALUES (:id_pedido, :id_producto, :cantidad)");
                    $stmt_detalle->bindParam(":id_pedido", $id_pedido, PDO::PARAM_INT);
                    $stmt_detalle->bindParam(":id_producto", $producto["id"], PDO::PARAM_INT);
                    $stmt_detalle->bindParam(":cantidad", $producto["cantidad"], PDO::PARAM_INT);
                    if (!$stmt_detalle->execute()) {
                        $errorInfo = $stmt_detalle->errorInfo();
                        echo "Error al ejecutar la consulta: " . $errorInfo[2];
                    }
                }

                // Confirmar la transacción si todas las consultas fueron exitosas
                $link->commit();

                // Log de auditoría
                Auditoria::escribirLog("Se insertó un nuevo pedido con ID: " . $id_pedido);
                //return true;
                return [$nuevoNro, true];
            } else {
                // Cancelar la transacción en caso de error
                $link->rollBack();
                // Se produjo un error al ejecutar la consulta
                $errorInfo = $stmt->errorInfo();
                echo "Error al ejecutar la consulta: " . $errorInfo[2];
                // Log de auditoría
                Auditoria::escribirLog("Error al guardar pedido nuevo: " . $errorInfo[2]);
                return false;
            }
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
        }
    }

    /*=============================================
	EDITAR PEDIDO AGREGO CONTROL QUE NO ESTÉ COBRADO
	=============================================*/
    static public function mdlEditarPedido($tabla, $datos)
    {
        try {
            // Iniciar la transacción
            $link = Conexion::conectar();
            $link->beginTransaction();

            // Consultar si el pedido tiene el grupo cerrado
            $stmt_estado_grupo = $link->prepare("SELECT estado, anulado, cerrado FROM $tabla WHERE id = :id_pedido");
            $stmt_estado_grupo->bindParam(":id_pedido", $datos["id_pedido"], PDO::PARAM_INT);
            if (!$stmt_estado_grupo->execute()) {
                $errorInfo = $stmt_estado_grupo->errorInfo();
                echo "Error al ejecutar la consulta select estado: " . $errorInfo[2];
                $link->rollBack();
                return false;
            }
            $resultado_estado_grupo = $stmt_estado_grupo->fetch(PDO::FETCH_ASSOC);
            $estado_cerrado = $resultado_estado_grupo['cerrado'];

            // Verificar si el estado actual es "IMPAGO"
            if (intval($estado_cerrado) == 1) {
                echo "El Grupo ya está cerrado, este pedido no puede ser editado.";
                $link->rollBack();
                return false;
            }

            // Consultar el estado actual del pedido
            $stmt_estado = $link->prepare("SELECT estado, anulado, cerrado FROM $tabla WHERE id = :id_pedido");
            $stmt_estado->bindParam(":id_pedido", $datos["id_pedido"], PDO::PARAM_INT);
            if (!$stmt_estado->execute()) {
                $errorInfo = $stmt_estado->errorInfo();
                echo "Error al ejecutar la consulta select estado: " . $errorInfo[2];
                $link->rollBack();
                return false;
            }
            $resultado_estado = $stmt_estado->fetch(PDO::FETCH_ASSOC);
            $estado_cerrado = $resultado_estado['cerrado'];
            $estado_anulado = $resultado_estado['anulado'];

            // Verificar si el estado actual es "IMPAGO"
            if ((intval($estado_cerrado) == 1 || intval($estado_anulado) == 1) && $_SESSION["perfil"] != "Administrador") {
                echo "El pedido ya ha sido cobrado y no puede ser editado.";
                $link->rollBack();
                return false;
            }

            // Eliminar los registros anteriores de pedidos_detalle
            $stmt_delete = $link->prepare("DELETE FROM pedidos_detalle WHERE id_pedido = :id_pedido");
            $stmt_delete->bindParam(":id_pedido", $datos["id_pedido"], PDO::PARAM_INT);
            if (!$stmt_delete->execute()) {
                $errorInfo = $stmt_delete->errorInfo();
                echo "Error al ejecutar la consulta delete pedidos_detalle: " . $errorInfo[2];
                $link->rollBack();
                return false;
            }

            // Actualizar los datos en la tabla principal (por ejemplo, tabla pedidos)
            $stmt_update = $link->prepare("UPDATE $tabla SET productos = :productos, importe_neto = :importe_neto, importe_total = :importe_total, importe_pago = :importe_pago, importe_debe = :importe_debe, descuento = :descuento, nro_habitacion = :nro_habitacion, nombre_pax = :nombre_pax, estado = :estado, cerrado = :cerrado, pago_en_hotel = :pagoEnHotel, fecha_pago = :fecha_pago WHERE id = :id_pedido");
            $stmt_update->bindParam(":id_pedido", $datos["id_pedido"], PDO::PARAM_INT);
            $stmt_update->bindParam(":productos", $datos["productos"], PDO::PARAM_STR);
            $stmt_update->bindParam(":importe_neto", $datos["importe_neto"], PDO::PARAM_STR);
            $stmt_update->bindParam(":importe_total", $datos["importe_total"], PDO::PARAM_STR);
            $stmt_update->bindParam(":descuento", $datos["descuento"], PDO::PARAM_STR);
            $stmt_update->bindParam(":importe_debe", $datos["importe_debe"], PDO::PARAM_STR);
            $stmt_update->bindParam(":importe_pago", $datos["nuevo_total_pago"], PDO::PARAM_STR);
            $stmt_update->bindParam(":nombre_pax", $datos["nombre_pax"], PDO::PARAM_STR);
            $stmt_update->bindParam(":nro_habitacion", $datos["nro_habitacion"], PDO::PARAM_STR);
            $stmt_update->bindParam(":estado", $datos["estado"], PDO::PARAM_STR);
            $stmt_update->bindParam(":cerrado", $datos["cerrado"], PDO::PARAM_STR);
            $stmt_update->bindParam(":pagoEnHotel", $datos["pago_en_hotel"], PDO::PARAM_STR);
            $stmt_update->bindParam(":fecha_pago", $datos["fecha_pago"], PDO::PARAM_STR);

            if (!$stmt_update->execute()) {
                $errorInfo = $stmt_update->errorInfo();
                echo "Error al ejecutar la consulta update pedidos: " . $errorInfo[2];
                $link->rollBack();
                return false;
            }

            // Insertar cada producto en la tabla pedidos_detalle
            $productos = json_decode($datos["productos"], true);
            foreach ($productos as $producto) {
                $stmt_detalle = $link->prepare("INSERT INTO pedidos_detalle(id_pedido, id_producto, cantidad) VALUES (:id_pedido, :id_producto, :cantidad)");
                $stmt_detalle->bindParam(":id_pedido", $datos["id_pedido"], PDO::PARAM_INT);
                $stmt_detalle->bindParam(":id_producto", $producto["id"], PDO::PARAM_INT);
                $stmt_detalle->bindParam(":cantidad", $producto["cantidad"], PDO::PARAM_INT);
                if (!$stmt_detalle->execute()) {
                    $errorInfo = $stmt_detalle->errorInfo();
                    echo "Error al ejecutar la consulta insert pedidos_detalle: " . $errorInfo[2];
                    $link->rollBack();
                    return false;
                }
            }

            // Confirmar la transacción si todas las consultas fueron exitosas
            $link->commit();
            // Log de auditoría
            Auditoria::escribirLog("Se editó pedido con ID: " . $datos["id_pedido"]);
            return Conexion::encryption($datos["id_pedido"]);
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
            $link->rollBack();
            // Log de auditoría
            Auditoria::escribirLog("Error al editar pedido con ID: {$datos["id_pedido"]}" . $e->getMessage());
            return false;
        }
    }

    /*=============================================
	EDITAR PEDIDO AGREGO CONTROL QUE NO ESTÉ COBRADO
	=============================================*/
    static public function mdlEditarPedidoAdmin($tabla, $datos)
    {
        try {
            // Iniciar la transacción
            $link = Conexion::conectar();
            $link->beginTransaction();

            // Consultar el estado actual del pedido
            $stmt_estado = $link->prepare("SELECT estado FROM $tabla WHERE id = :id_pedido");
            $stmt_estado->bindParam(":id_pedido", $datos["id_pedido"], PDO::PARAM_INT);
            if (!$stmt_estado->execute()) {
                $errorInfo = $stmt_estado->errorInfo();
                echo "Error al ejecutar la consulta select estado: " . $errorInfo[2];
                $link->rollBack();
                return false;
            }
            $resultado_estado = $stmt_estado->fetch(PDO::FETCH_ASSOC);

            // Eliminar los registros anteriores de pedidos_detalle
            $stmt_delete = $link->prepare("DELETE FROM pedidos_detalle WHERE id_pedido = :id_pedido");
            $stmt_delete->bindParam(":id_pedido", $datos["id_pedido"], PDO::PARAM_INT);
            if (!$stmt_delete->execute()) {
                $errorInfo = $stmt_delete->errorInfo();
                echo "Error al ejecutar la consulta delete pedidos_detalle: " . $errorInfo[2];
                $link->rollBack();
                return false;
            }

            // Actualizar los datos en la tabla principal (por ejemplo, tabla pedidos)
            $stmt_update = $link->prepare("UPDATE $tabla SET productos = :productos, importe_neto = :importe_neto, importe_total = :importe_total, importe_pago = :importe_pago, importe_debe = :importe_debe, descuento = :descuento, nro_habitacion = :nro_habitacion, nombre_pax = :nombre_pax, pago_en_hotel = :pagoEnHotel WHERE id = :id_pedido");
            $stmt_update->bindParam(":id_pedido", $datos["id_pedido"], PDO::PARAM_INT);
            $stmt_update->bindParam(":productos", $datos["productos"], PDO::PARAM_STR);
            $stmt_update->bindParam(":importe_neto", $datos["importe_neto"], PDO::PARAM_STR);
            $stmt_update->bindParam(":importe_total", $datos["importe_total"], PDO::PARAM_STR);
            $stmt_update->bindParam(":descuento", $datos["descuento"], PDO::PARAM_STR);
            $stmt_update->bindParam(":importe_debe", $datos["importe_debe"], PDO::PARAM_STR);
            $stmt_update->bindParam(":importe_pago", $datos["nuevo_total_pago"], PDO::PARAM_STR);
            $stmt_update->bindParam(":nombre_pax", $datos["nombre_pax"], PDO::PARAM_STR);
            $stmt_update->bindParam(":nro_habitacion", $datos["nro_habitacion"], PDO::PARAM_STR);
            $stmt_update->bindParam(":pagoEnHotel", $datos["pago_en_hotel"], PDO::PARAM_STR);

            if (!$stmt_update->execute()) {
                $errorInfo = $stmt_update->errorInfo();
                echo "Error al ejecutar la consulta update pedidos: " . $errorInfo[2];
                $link->rollBack();
                return false;
            }

            // Insertar cada producto en la tabla pedidos_detalle
            $productos = json_decode($datos["productos"], true);
            foreach ($productos as $producto) {
                $stmt_detalle = $link->prepare("INSERT INTO pedidos_detalle(id_pedido, id_producto, cantidad) VALUES (:id_pedido, :id_producto, :cantidad)");
                $stmt_detalle->bindParam(":id_pedido", $datos["id_pedido"], PDO::PARAM_INT);
                $stmt_detalle->bindParam(":id_producto", $producto["id"], PDO::PARAM_INT);
                $stmt_detalle->bindParam(":cantidad", $producto["cantidad"], PDO::PARAM_INT);
                if (!$stmt_detalle->execute()) {
                    $errorInfo = $stmt_detalle->errorInfo();
                    echo "Error al ejecutar la consulta insert pedidos_detalle: " . $errorInfo[2];
                    $link->rollBack();
                    return false;
                }
            }

            // Confirmar la transacción si todas las consultas fueron exitosas
            $link->commit();
            // Log de auditoría
            Auditoria::escribirLog("Se editó pedido (ADMIN) con ID: " . $datos["id_pedido"]);
            return Conexion::encryption($datos["id_pedido"]);
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
            $link->rollBack();
            return false;
        }
    }

    /*=============================================
	EDITAR PEDIDO COBRAR
	=============================================*/

    static public function mdlCobrarPedido($tabla, $datos)
    {
        try {
            // Iniciar la transacción
            $link = Conexion::conectar();
            $link->beginTransaction();


            // Actualizar los datos en la tabla principal (por ejemplo, tabla pedidos)
            $stmt_update = $link->prepare("UPDATE $tabla SET estado = :estado, cerrado = :cerrado, fecha_pago = :fecha_pago WHERE id = :id_pedido");
            $stmt_update->bindParam(":estado", $datos["estado"], PDO::PARAM_STR);
            $stmt_update->bindParam(":id_pedido", $datos["id_pedido"], PDO::PARAM_INT);
            $stmt_update->bindParam(":cerrado", $datos["cerrado"], PDO::PARAM_INT);
            $stmt_update->bindParam(":fecha_pago", $datos["fecha_pago"], PDO::PARAM_STR);

            if (!$stmt_update->execute()) {
                $errorInfo = $stmt_update->errorInfo();
                echo "Error al ejecutar la consulta update pedido: " . $errorInfo[2];
                $link->rollBack();
                return false;
            }

            // Confirmar la transacción si todas las consultas fueron exitosas
            $link->commit();

            return true;
        } catch (PDOException $e) {
            // Manejar cualquier excepción de la base de datos
            echo "Error: " . $e->getMessage();
            $link->rollBack();
            return false;
        }
    }


    /*=============================================
	ELIMINAR PEDIDO
	=============================================*/

    static public function mdlEliminarPedido($tabla, $datos)
    {
        $pedido = Conexion::decryption($datos);

        try {
            // Iniciar una transacción
            $conn = Conexion::conectar();
            $conn->beginTransaction();

            // Se cambia eliminar pedido por anular, el mismo agrega un 1 en el atributo anulado
            $stmtPedido = $conn->prepare("UPDATE $tabla SET anulado = 1 WHERE id = :id");
            $stmtPedido->bindParam(":id", $pedido, PDO::PARAM_INT);
            $stmtPedido->execute();

            // Si ambas consultas se ejecutan sin errores, confirmar la transacción
            $conn->commit();

            // Log de auditoría
            Auditoria::escribirLog("Se anuló pedido con ID: " . $pedido);

            return true;
        } catch (PDOException $e) {
            // En caso de error, deshacer la transacción
            $conn->rollBack();

            // Manejo de excepciones
            echo "Error: " . $e->getMessage();
            return false;
        }
    }



    /*=============================================
	Historial de pedidos
	=============================================*/

    static public function mdlHistorialPedidos($tabla, $fechaInicial, $fechaFinal)
    {
        $fechaActual = date('Y-m-d');
        if ($fechaInicial == null) {

            $sql = "SELECT * FROM $tabla ORDER BY id, id_coordinador DESC";
            $stmt = Conexion::conectar()->prepare($sql);
            $stmt->execute();
        } else if ($fechaInicial == $fechaFinal) {

            $sql = "SELECT * FROM $tabla WHERE fecha like '%$fechaFinal%' ORDER BY id, id_coordinador DESC";
            $stmt = Conexion::conectar()->prepare($sql);
            $stmt->bindParam(":fecha", $fechaFinal, PDO::PARAM_STR);
            $stmt->execute();
        } else {

            $fechaActual = new DateTime();
            $fechaActual->add(new DateInterval("P1D"));
            $fechaActualMasUno = $fechaActual->format("Y-m-d");

            $fechaFinal2 = new DateTime($fechaFinal);
            $fechaFinal2->add(new DateInterval("P1D"));
            $fechaFinalMasUno = $fechaFinal2->format("Y-m-d");

            if ($fechaFinalMasUno == $fechaActualMasUno) {

                $sql = "SELECT * FROM $tabla WHERE fecha BETWEEN '$fechaInicial' AND '$fechaFinalMasUno' ORDER BY id, id_coordinador DESC";
                $stmt = Conexion::conectar()->prepare($sql);
            } else {

                $sql = "SELECT * FROM $tabla WHERE fecha BETWEEN '$fechaInicial' AND '$fechaFinal' ORDER BY id, id_coordinador DESC";
                $stmt = Conexion::conectar()->prepare($sql);
            }

            $stmt->execute();
        }

        return $stmt->fetchAll();
    }


    /*=============================================
	RANGO FECHAS
	=============================================*/
    static public function mdlRangoFechasPedidos($tabla, $fechaInicial, $fechaFinal, $usuario, $cerrado)
    {
        $fechaActual = date('Y-m-d');
        $auxCerrado = $cerrado == null ? " AND cerrado IS NULL " : " AND cerrado = $cerrado";
        if ($fechaInicial == null) {

            if ($usuario != null) {

                if ($_SESSION["perfil"] == "Vendedor") {
                    $sql = "SELECT * FROM $tabla WHERE fecha = '$fechaActual' AND id_vendedor = $usuario AND cerrado IS NULL ORDER BY id, id_coordinador ASC";
                    $stmt = Conexion::conectar()->prepare($sql);
                    $stmt->execute();
                } else {
                    $sql = "SELECT * FROM $tabla WHERE fecha = '$fechaActual' AND (anulado is null or anulado = 0) $auxCerrado ORDER BY id_coordinador ASC";
                    $stmt = Conexion::conectar()->prepare($sql);
                    $stmt->execute();
                }
            } else {
                $sql = "SELECT * FROM $tabla WHERE fecha = '$fechaActual' AND (anulado is null or anulado = 0) $auxCerrado ORDER BY id, id_coordinador ASC";
                $stmt = Conexion::conectar()->prepare($sql);
                $stmt->execute();
            }

            return $stmt->fetchAll();
        } else if ($fechaInicial == $fechaFinal) {

            $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE fecha like '%$fechaFinal%' AND (anulado is null or anulado = 0) $auxCerrado ORDER BY id ASC");

            $stmt->bindParam(":fecha", $fechaFinal, PDO::PARAM_STR);

            $stmt->execute();

            return $stmt->fetchAll();
        } else {

            $fechaActual = new DateTime();
            $fechaActual->add(new DateInterval("P1D"));
            $fechaActualMasUno = $fechaActual->format("Y-m-d");

            $fechaFinal2 = new DateTime($fechaFinal);
            $fechaFinal2->add(new DateInterval("P1D"));
            $fechaFinalMasUno = $fechaFinal2->format("Y-m-d");

            if ($fechaFinalMasUno == $fechaActualMasUno) {

                $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE fecha BETWEEN '$fechaInicial' AND '$fechaFinalMasUno' AND (anulado is null or anulado = 0) AND cerrado = $cerrado ORDER BY id ASC");
            } else {


                $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE fecha BETWEEN '$fechaInicial' AND '$fechaFinal' AND (anulado is null or anulado = 0) AND cerrado = $cerrado ORDER BY id ASC");
            }

            $stmt->execute();

            return $stmt->fetchAll();
        }
    }

    /*=============================================
	PEDIDOS POR GRUPO
	=============================================*/
    static public function mdlPedidosPorGrupo($fechaInicial, $cerrado)
    {
        // Obtener la fecha actual
        $fechaActual = $fechaInicial != null ? $fechaInicial : date('Y-m-d');

        if(!$cerrado == true){
            $filtro = " AND cerrado IS NULL";
        }else{
            $filtro = " AND NOT cerrado IS NULL";
        }

        $query = "SELECT *, coordinadores.id as idCoordinador, coordinadores.nombre as coordinador, empresas.nombre as empresa, hoteles.nombre as hotel FROM coordinadores
        LEFT JOIN empresas ON coordinadores.id_empresa = empresas.id
        LEFT JOIN hoteles ON coordinadores.id_hotel = hoteles.id
        WHERE DATE(coordinadores.fecha_alta) = '$fechaActual' $filtro ORDER BY coordinadores.creado ASC;";
        $stmt = Conexion::conectar()->prepare($query);
        $stmt->execute();

        return $stmt->fetchAll();
    }

    /*=============================================
	PEDIDOS POR GRUPO CERRADOS
	=============================================*/
    static public function mdlPedidosPorGrupoCerrados($fechaInicial)
    {
        // Obtener la fecha actual
        $fechaActual = $fechaInicial != null ? " WHERE DATE(coordinadores.fecha_alta) = '{$fechaInicial}'" : "";

        $query = "SELECT *, coordinadores.id as idCoordinador, coordinadores.nombre as coordinador, empresas.nombre as empresa, hoteles.nombre as hotel FROM coordinadores
        LEFT JOIN empresas ON coordinadores.id_empresa = empresas.id
        LEFT JOIN hoteles ON coordinadores.id_hotel = hoteles.id
        WHERE cerrado = 1
        ORDER BY coordinadores.creado ASC;";
        $stmt = Conexion::conectar()->prepare($query);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    /*=============================================
	RANGO FECHAS POR COORDINADOR
	=============================================*/

    static public function mdlRangoFechasVentasCoordinador($tabla, $fechaInicial, $fechaFinal, $coordinador)
    {

        if ($fechaInicial == null) {

            $sql = "SELECT * FROM $tabla WHERE id_coordinador = $coordinador AND (anulado is null or anulado = 0) ORDER BY id ASC";
            $stmt = Conexion::conectar()->prepare($sql);
        } else if ($fechaInicial == $fechaFinal) {

            $sql = "SELECT * FROM $tabla WHERE id_coordinador = $coordinador AND (anulado is null or anulado = 0) AND fecha like '%$fechaFinal%' ORDER BY id ASC";
            $stmt = Conexion::conectar()->prepare($sql);
            $stmt->bindParam(":fecha", $fechaFinal, PDO::PARAM_STR);
        } else {

            $fechaActual = new DateTime();
            $fechaActual->add(new DateInterval("P1D"));
            $fechaActualMasUno = $fechaActual->format("Y-m-d");

            $fechaFinal2 = new DateTime($fechaFinal);
            $fechaFinal2->add(new DateInterval("P1D"));
            $fechaFinalMasUno = $fechaFinal2->format("Y-m-d");

            if ($fechaFinalMasUno == $fechaActualMasUno) {
                $sql = "SELECT * FROM $tabla WHERE id_coordinador = $coordinador AND fecha BETWEEN '$fechaInicial' AND '$fechaFinalMasUno'";
                $stmt = Conexion::conectar()->prepare($sql);
            } else {
                $sql = "SELECT * FROM $tabla WHERE id_coordinador = $coordinador AND fecha BETWEEN '$fechaInicial' AND '$fechaFinal'";
                $stmt = Conexion::conectar()->prepare($sql);
            }
        }

        $stmt->execute();
        return $stmt->fetchAll();
    }

    /*=============================================
	SUMAR EL TOTAL DE PEDIDOS DEL DÍA
	=============================================*/

    static public function mdlSumaTotalPedidos($tabla)
    {
        $fechaActual = date('Y-m-d');
        $stmt = Conexion::conectar()->prepare("SELECT count(*) as cantidad, SUM(importe_neto) as total FROM $tabla WHERE fecha = '$fechaActual' AND cerrado IS NULL AND anulado IS NULL");

        $stmt->execute();

        $result = $stmt->fetch();

        $stmt->closeCursor();

        $stmt = null;

        return $result;
    }
}
