<?php

// Declaramos la librería
require "autoload.php";
require_once "../modelos/conexion.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Crear una instancia de Spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Establecer encabezados de columna
$sheet->setCellValue('A1', 'Coordinador');
$sheet->setCellValue('B1', 'Importe Total');

// Conectarse a la base de datos
// Crear conexión a la base de datos
$conn = Conexion::obtenerConexion();
if ($conn->connect_error) {
    die("Error de conexión a la base de datos: " . $conn->connect_error);
}

// Consulta SQL con left join entre las tablas
$sql = "SELECT c.nombre AS coordinador, SUM(p.importe_total) AS importe_total
        FROM pedidos p
        LEFT JOIN coordinadores c ON p.id_coordinador = c.id
        GROUP BY p.id_coordinador";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Escribir los datos en el archivo Excel
    $row = 2; // Comenzar en la fila 2, después de los encabezados de columna
    while ($row_data = $result->fetch_assoc()) {
        $sheet->setCellValue('A' . $row, $row_data['coordinador']);
        $sheet->setCellValue('B' . $row, $row_data['importe_total']);
        $row++;
    }
} else {
    echo "No se encontraron resultados.";
}

// Guardar el archivo Excel
$writer = new Xlsx($spreadsheet);
$writer->save('reporte.xlsx');

// Cerrar la conexión a la base de datos
$conn->close();

echo "El reporte se ha generado correctamente.";

?>
