<?php
date_default_timezone_set('America/Argentina/Buenos_Aires');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once "autoload.php";
require_once "../modelos/conexion.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Obtener el resultado de la consulta
$idCoordinador = Conexion::decryption($_GET["coordinador"]);
// Establecer la conexión a la base de datos
$conn = Conexion::obtenerConexion();
$query = "SELECT empresas.nombre AS nombre_empresa, pedidos.id AS numero_pedido, pedidos.nombre_pax AS pasajero, pedidos.nro_habitacion AS habitacion, coordinadores.fecha_entrega,
          coordinadores.nombre as nombre_coordinador, pedidos.importe_total FROM pedidos
          LEFT JOIN coordinadores ON pedidos.id_coordinador = coordinadores.id
          LEFT JOIN empresas ON empresas.id = coordinadores.id_empresa WHERE coordinadores.id = $idCoordinador AND pedidos.cerrado = 1";
$result = $conn->query($query);

// Crear un nuevo objeto Spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Agregar datos de cabecera en la parte superior
$sheet->setCellValue('A1', 'Nombre Empresa: ');
$sheet->setCellValue('B1', 'Nombre Hotel: ');
$sheet->setCellValue('C1', 'Nombre Coordinador: ');

// Obtener los datos de la empresa y otros detalles
$empresa = '';
$hotel = '';
$coordinador = '';

while ($row_data = $result->fetch_assoc()) {
    if (empty($empresa)) {
        $empresa = $row_data['nombre_empresa'];
        $hotel = $row_data['nombre_hotel'];
        $coordinador = $row_data['nombre_coordinador'];

        // Agregar datos de cabecera en la parte superior
        $sheet->setCellValue('A2', $empresa);
        $sheet->setCellValue('B2', $hotel);
        $sheet->setCellValue('C2', $coordinador);
    }
}

// Agregar encabezados de columna debajo de los datos de cabecera
$sheet->setCellValue('A4', 'Número Pedido');
$sheet->setCellValue('B4', 'Nombre Pax');
$sheet->setCellValue('C4', 'Número de Habitación');
$sheet->setCellValue('D4', 'Importe');

// Agregar datos de cada pedido debajo de los encabezados
$row = 5;
$result->data_seek(0); // Reiniciar el puntero del resultado para volver a leer desde el principio

while ($row_data = $result->fetch_assoc()) {
    $sheet->setCellValue('A' . $row, $row_data['numero_pedido']);
    $sheet->setCellValue('B' . $row, $row_data['pasajero']);
    $sheet->setCellValue('C' . $row, $row_data['habitacion']);
    $sheet->setCellValue('D' . $row, $row_data['importe_total']);
    $row++;
}

// Crear un objeto Writer para guardar el archivo de Excel
$writer = new Xlsx($spreadsheet);

// Definir las cabeceras del archivo
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="archivo_excel.xlsx"');
header('Cache-Control: max-age=0');

// Guardar el archivo en la salida de respuesta
$writer->save('php://output');
