<?php
// Declaramos la librería
require "autoload.php";
require_once "../modelos/conexion.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
// Obtener el ID del coordinador deseado
$id_coordinador = Conexion::decryption($_GET["coordinador"]); // Reemplaza con el ID del coordinador deseado

// Crear conexión a la base de datos
$conn = Conexion::obtenerConexion();

// Verificar la conexión
if ($conn->connect_error) {
    die('Error de conexión a la base de datos: ' . $conn->connect_error);
}

// Consulta SQL para obtener los pedidos con los productos del coordinador especificado
$sql = "SELECT p.id AS id_pedido, p.codigo, p.fecha, c.nombre AS coordinador, pd.id_producto, pd.cantidad, pr.descripcion, pr.precio_venta
        FROM pedidos p
        INNER JOIN pedidos_detalle pd ON p.id = pd.id_pedido
        INNER JOIN productos pr ON pd.id_producto = pr.id
        INNER JOIN coordinadores c ON p.id_coordinador = c.id
        WHERE p.id_coordinador = $id_coordinador AND p.cerrado = 1
        ORDER BY p.id";

// Ejecutar la consulta SQL
$result = $conn->query($sql);

// Crear un nuevo objeto Spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Establecer las cabeceras del reporte en Excel
$sheet->setCellValue('A1', 'ID Pedido');
$sheet->setCellValue('B1', 'Código');
$sheet->setCellValue('C1', 'Fecha');
$sheet->setCellValue('D1', 'Coordinador');
$sheet->setCellValue('E1', 'ID Producto');
$sheet->setCellValue('F1', 'Cantidad');
$sheet->setCellValue('G1', 'Descripción');
$sheet->setCellValue('H1', 'Precio Venta');

// Iterar sobre los resultados de la consulta y escribir los datos en las celdas correspondientes
$row = 2; // Fila inicial para los datos
while ($row_data = $result->fetch_assoc()) {
    $sheet->setCellValue('A' . $row, $row_data['id_pedido']);
    $sheet->setCellValue('B' . $row, $row_data['codigo']);
    $sheet->setCellValue('C' . $row, $row_data['fecha']);
    $sheet->setCellValue('D' . $row, $row_data['coordinador']);
    $sheet->setCellValue('E' . $row, $row_data['id_producto']);
    $sheet->setCellValue('F' . $row, $row_data['cantidad']);
    $sheet->setCellValue('G' . $row, $row_data['descripcion']);
    $sheet->setCellValue('H' . $row, $row_data['precio_venta']);
    $row++;
}

// Crear el objeto Writer para guardar el archivo Excel
$writer = new Xlsx($spreadsheet);

// Guardar el archivo Excel en el servidor
$filename = 'reporte.xlsx';
$writer->save($filename);

// Descargar el archivo Excel generado
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'. $filename .'"');
header('Cache-Control: max-age=0');
readfile($filename);
unlink($filename); // Eliminar el archivo después de descargarlo

// Cerrar la conexión a la base de datos
$conn->close();
