<?php

// Declaramos la librería
require "autoload.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

require_once "../controladores/pedidos.controlador.php";
require_once "../modelos/pedidos.modelo.php";

require_once "../controladores/coordinadores.controlador.php";
require_once "../modelos/coordinadores.modelo.php";

require_once "../controladores/usuarios.controlador.php";
require_once "../modelos/usuarios.modelo.php";

require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";

$spread = new Spreadsheet();

// Obtener la hoja activa del documento
$sheet = $spread->getActiveSheet();

// Definir los encabezados de las columnas en la hoja principal
$sheet->setCellValue('A1', 'Código');
$sheet->setCellValue('B1', 'Fecha');
$sheet->setCellValue('C1', 'ID Vendedor');
$sheet->setCellValue('D1', 'ID Coordinador');
$sheet->setCellValue('E1', 'Importe Neto');
$sheet->setCellValue('F1', 'Importe Total');
$sheet->setCellValue('G1', 'Descuento');
$sheet->setCellValue('H1', 'Fecha de Entrega');
$sheet->setCellValue('I1', 'Nombre Pax');
$sheet->setCellValue('J1', 'Nro Habitación');
$sheet->setCellValue('K1', 'Estado');
$sheet->setCellValue('L1', 'Fecha del Sistema');

$itemPedido = "id";
$valorPedido = Conexion::decryption($_GET["idPedido"]);
$respuestaPedido = ControladorPedidos::ctrMostrarPedidos($itemPedido, $valorPedido);

$data = array($respuestaPedido);

// Recorrer los datos y agregarlos a las celdas correspondientes en la hoja principal
$row = 2; // Comenzar en la fila 2 para dejar la primera fila para los encabezados
foreach ($data as $item) {
    $sheet->setCellValue('A' . $row, $item['id']);
    $sheet->setCellValue('B' . $row, $item['fecha']);
    $sheet->setCellValue('C' . $row, $item['id_vendedor']);
    $sheet->setCellValue('D' . $row, $item['id_coordinador']);
    $sheet->setCellValue('E' . $row, $item['importe_neto']);
    $sheet->setCellValue('F' . $row, $item['importe_total']);
    $sheet->setCellValue('G' . $row, $item['descuento']);
    $sheet->setCellValue('H' . $row, $item['fecha_entrega']);
    $sheet->setCellValue('I' . $row, $item['nombre_pax']);
    $sheet->setCellValue('J' . $row, $item['nro_habitacion']);
    $sheet->setCellValue('K' . $row, $item['estado']);
    $sheet->setCellValue('L' . $row, $item['fecha_sistema']);
    $row++;
}

// Crear una nueva hoja para el detalle de los productos
$detailSheet = $spread->createSheet();
$detailSheet->setTitle('Detalle Productos');

// Definir los encabezados de las columnas en la hoja de detalle de productos
$detailSheet->setCellValue('A1', 'Descripción');
$detailSheet->setCellValue('B1', 'Cantidad');
$detailSheet->setCellValue('C1', 'Precio');
$detailSheet->setCellValue('D1', 'Total');

// Obtener los productos y agregarlos a las celdas correspondientes en la hoja de detalle
$products = json_decode($data[0]['productos'], true);
$row = 2; // Comenzar en la fila 2 para dejar la primera fila para los encabezados
foreach ($products as $product) {
    $detailSheet->setCellValue('A' . $row, $product['descripcion']);
    $detailSheet->setCellValue('B' . $row, $product['cantidad']);
    $detailSheet->setCellValue('C' . $row, $product['precio']);
    $detailSheet->setCellValue('D' . $row, $product['total']);
    $row++;
}

// Definir los anchos de las columnas
$columnWidths = [
    'A' => 15,
    'B' => 15,
    'C' => 20,
    'D' => 15,
    'E' => 15,
    'F' => 15,
    'G' => 15,
    'H' => 20,
    'I' => 15,
    'J' => 15,
    'K' => 10,
    'L' => 20,
];

// Ajustar el ancho de las columnas en la hoja principal
foreach ($columnWidths as $column => $width) {
    $sheet->getColumnDimension($column)->setWidth($width);
}

// Ajustar el ancho de las columnas en la hoja de detalle de productos
foreach ($columnWidths as $column => $width) {
    $detailSheet->getColumnDimension($column)->setWidth($width);
}

$date = date("d-m-y");
$fileName = "reporte_pedido_".$date.".xlsx";
$writer = new Xlsx($spread);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
$writer->save('php://output');
?>
