<div class="content-wrapper">
    <section class="content-header">
        <h1>Historial de Pedidos</h1>
        <ol class="breadcrumb">
            <li><a href="inicio"><i class="fa fa-dashboard"></i> Inicio</a></li>
            <li class="active">Historial de pedidos</li>
        </ol>
    </section>

    <section class="content">
        <div class="box">
            <div class="box-body">
                <form id="formHistorialPedidos" class="form-inline mb-3">
                    <div class="form-group mx-sm-3 mb-2">
                        <label for="fechaInicial" class="sr-only">Fecha Inicial:</label>
                        <input type="date" id="fechaInicial" name="fechaInicial" class="form-control" required>
                    </div>

                    <div class="form-group mx-sm-3 mb-2">
                        <label for="fechaFinal" class="sr-only">Fecha Final:</label>
                        <input type="date" id="fechaFinal" name="fechaFinal" class="form-control" required>
                    </div>

                    <button type="submit" class="btn btn-primary mb-2">Buscar</button>
                </form>
                <!-- Mensaje de fechas filtradas -->
                <div id="fechasFiltrado" style="font-size: 18px; margin-bottom: 20px;"></div>
                <br>
                <table id="tablaUsuarios" class="table table-striped table-bordered table-condensed" style="width:100%">
                    <thead>
                        <tr>
                            <th>Nro.</th>
                            <th>Fecha</th>
                            <th>Empresa</th>
                            <th>Coordinador</th>
                            <th>PAX</th>
                            <th>Total</th>
                            <th>Estado</th>
                            <th>Cerrado</th>
                            <th>Anulado</th>
                            <th>Fecha Entrega</th>
                            <th style="text-align: right;">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Aquí van las filas de datos -->
                    </tbody>
                </table>
            </div>
        </div>
    </section>

</div>
<!-- DataTables CSS -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.0/css/jquery.dataTables.css">

<!-- jQuery (necesario para DataTables) 
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>-->

<!-- DataTables JS -->
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.13.0/js/jquery.dataTables.js"></script>

<script>
    $(document).ready(function() {
        var table = $("#tablaUsuarios").DataTable({
            "processing": true,
            "serverSide": true,
            "paging": true, // Habilitar el paginado
            "lengthMenu": [10, 25, 50, 100], // Opciones de paginado
            "pageLength": 50,
            "order": [
                [0, "desc"]
            ],
            "ajax": {
                "url": "../app/ajax/ajaxPedidos.php",
                "type": "POST",
                "data": function(d) {
                    d.fechaInicial = $('#fechaInicial').val();
                    d.fechaFinal = $('#fechaFinal').val();
                }
            },
            "columns": [{
                    "data": "id"
                },
                {
                    "data": "fecha"
                },
                {
                    "data": "empresa"
                },
                {
                    "data": "coordinador_nombre"
                },
                {
                    "data": "nombre_pax"
                },
                {
                    "data": "importe_total"
                },
                {
                    "data": "estado"
                },
                {
                    "data": "cerrado"
                },
                {
                    "data": "anulado"
                },
                {
                    "data": "fecha_entrega"
                },
                {
                "data": null,
                "render": function(data, type, row) {
                    var idPedido = row.id; // Suponiendo que 'id' es el identificador del pedido
                    return '<button class="btn btn-info btnVerPedidoHistorial" IdPedido="' + idPedido + '">' +
                           '<i class="fa fa-eye"></i>' +
                           '</button>';
                },
                "orderable": false
            }

            ],
            "language": {
                "sProcessing": "Procesando...",
                "sLengthMenu": "Mostrar _MENU_ registros",
                "sZeroRecords": "No se encontraron resultados",
                "sEmptyTable": "Ningún dato disponible en esta tabla",
                "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
                "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
                "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
                "sInfoPostFix": "",
                "sSearch": "Buscar:",
                "sUrl": "",
                "sInfoThousands": ",",
                "sLoadingRecords": "Cargando...",
                "oPaginate": {
                    "sFirst": "Primero",
                    "sLast": "Último",
                    "sNext": "Siguiente",
                    "sPrevious": "Anterior"
                },
                "oAria": {
                    "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                    "sSortDescending": ": Activar para ordenar la columna de manera descendente"
                }
            }
        });

        // Cuando se envíe el formulario, recargar la tabla
        $('#formHistorialPedidos').on('submit', function(e) {
            e.preventDefault();
            var fechaInicial = $('#fechaInicial').val().split('-').reverse().join('/');
            var fechaFinal = $('#fechaFinal').val().split('-').reverse().join('/');
            table.ajax.reload(); // Recargar la tabla con las nuevas fechas
            $('#fechasFiltrado').text('Filtrando desde: ' + fechaInicial + ' hasta: ' + fechaFinal);
        });
    });
</script>

<div id="dataModal" class="modal fade">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Detalle Pedido</h4>
      </div>
      <div class="modal-body" id="detalles">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>